package cc.jq1024.middleware.token.config;

import cc.jq1024.middleware.token.service.ITokenService;
import cc.jq1024.middleware.token.service.impl.TokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

/**
 * token 自动装配配置
 * @author li--jiaqiang
 */
@Configuration
@ConditionalOnClass(TokenProperties.class)
@EnableConfigurationProperties(TokenProperties.class)
public class TokenAutoConfigure {

    private static final Logger log = LoggerFactory.getLogger(TokenAutoConfigure.class);

    @PostConstruct
    public void init() {
        log.info("middleware token-service init...");
    }

    @Bean("tokenService")
    public ITokenService tokenService(TokenProperties properties) throws IllegalAccessException {
        verifyProperties(properties);
        return new TokenService(properties);
    }

    private void verifyProperties(TokenProperties properties) throws IllegalAccessException {
        if (null == properties.getTtl()) {
            throw new IllegalAccessException("jwt ttl is null.");
        }
        if (properties.getTtl() <= 0) {
            throw new IllegalAccessException("jwt ttl must be bigger than zero, the unit is millisecond.");
        }
        if (null == properties.getIssuer() || properties.getIssuer().isEmpty()) {
            throw new IllegalAccessException("jwt issuer is empty.");
        }
        if (null == properties.getSecretKey() || properties.getSecretKey().isEmpty()) {
            throw new IllegalAccessException("jwt secretKey is empty.");
        }
    }

}