package cc.jq1024.middleware.token.service;

import io.jsonwebtoken.Claims;

import java.util.HashMap;

/**
 * @author li--jiaqiang
 */
public interface ITokenService {

    /**
     * 生成token
     * @param claims 用户信息
     * @return token
     */
    String createJWT(HashMap<String, Object> claims);

    /** 生成token */
    String createJWT(String id, HashMap<String, Object> claims, Long ttlMillis);

    /** 生成无感刷新中的 refreshToken */
    String createRefreshJWT(HashMap<String, Object> claims);

    /** 解析token */
    Claims decode(String jwtToken);

    /** 验证token是否被篡改 */
    boolean isVerify(String jwtToken);

    /** 获取 Claims 中的某个字段值 */
    String propertyValue(String jwtToken, String property);

}