package cc.jq1024.middleware.token.service;

import cc.jq1024.middleware.token.config.TokenProperties;
import com.auth0.jwt.algorithms.Algorithm;
import org.apache.tomcat.util.codec.binary.Base64;

import java.nio.charset.StandardCharsets;
import java.util.UUID;

/**
 * @author li--jiaqiang
 */
public class TokenServiceSupport {

    protected final TokenProperties tokenProperties;

    protected TokenServiceSupport(TokenProperties tokenProperties) {
        this.tokenProperties = tokenProperties;
    }

    /**
     * 生成base64加密后的秘钥 secretKey
     */
    protected String encodeBase64SecretKey() {
        return Base64.encodeBase64String(tokenProperties.getSecretKey().getBytes(StandardCharsets.UTF_8));
    }

    /**
     * HS256加密
     */
    protected Algorithm encodeHS256SecretKey() {
        return Algorithm.HMAC256(Base64.decodeBase64(Base64.encodeBase64String(tokenProperties.getSecretKey().getBytes(StandardCharsets.UTF_8))));
    }

    /**
     * id 生成器
     * @return uuid
     */
    protected String getUUID(){
        return UUID.randomUUID().toString();
    }



}