/*
 * Decompiled with CFR 0.152.
 */
package com.holly.unit.dsctn.context;

import com.alibaba.druid.pool.DruidDataSource;
import com.holly.unit.db.api.factory.DruidDatasourceFactory;
import com.holly.unit.db.api.pojo.druid.DruidProperties;
import com.holly.unit.dsctn.persist.DataBaseInfoPersistence;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DataSourceContext {
    private static final Map<String, DataSource> DATA_SOURCES = new ConcurrentHashMap<String, DataSource>();
    private static Map<String, DruidProperties> DATA_SOURCES_CONF = new ConcurrentHashMap<String, DruidProperties>();

    public static void initDataSource(DruidProperties masterDataSourceProperties, DataSource dataSourcePrimary) {
        new DataBaseInfoPersistence(masterDataSourceProperties).deleteMasterDatabaseInfo();
        new DataBaseInfoPersistence(masterDataSourceProperties).createMasterDatabaseInfo();
        DataBaseInfoPersistence dataBaseInfoDao = new DataBaseInfoPersistence(masterDataSourceProperties);
        Map<String, DruidProperties> allDataBaseInfo = dataBaseInfoDao.getAllDataBaseInfo();
        DATA_SOURCES_CONF = allDataBaseInfo;
        for (Map.Entry<String, DruidProperties> entry : allDataBaseInfo.entrySet()) {
            String dbName = entry.getKey();
            DruidProperties druidProperties = entry.getValue();
            if (dbName.equalsIgnoreCase("master")) {
                DATA_SOURCES_CONF.put(dbName, druidProperties);
                DATA_SOURCES.put(dbName, dataSourcePrimary);
                continue;
            }
            DataSource dataSource = DataSourceContext.createDataSource(dbName, druidProperties);
            DATA_SOURCES.put(dbName, dataSource);
        }
    }

    public static void addDataSource(String dbName, DataSource dataSource, DruidProperties druidProperties) {
        DATA_SOURCES.put(dbName, dataSource);
        DATA_SOURCES_CONF.put(dbName, druidProperties);
    }

    public static Map<String, DataSource> getDataSources() {
        return DATA_SOURCES;
    }

    public static Map<String, DruidProperties> getDataSourcesConfs() {
        return DATA_SOURCES_CONF;
    }

    public static void removeDataSource(String dataSourceName) {
        DataSource dataSource = DATA_SOURCES.get(dataSourceName);
        if (dataSource instanceof DruidDataSource) {
            ((DruidDataSource)dataSource).close();
        }
        DATA_SOURCES.remove(dataSourceName);
        DATA_SOURCES_CONF.remove(dataSourceName);
    }

    private static DataSource createDataSource(String dataSourceName, DruidProperties druidProperties) {
        DATA_SOURCES_CONF.put(dataSourceName, druidProperties);
        return DruidDatasourceFactory.createDruidDataSource((DruidProperties)druidProperties);
    }
}

