/*
 * Decompiled with CFR 0.152.
 */
package com.holly.unit.dsctn.listener;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.holly.unit.core.exception.AbstractExceptionEnum;
import com.holly.unit.core.listener.ContextInitializedListener;
import com.holly.unit.db.api.factory.DruidDatasourceFactory;
import com.holly.unit.db.api.pojo.druid.DruidProperties;
import com.holly.unit.dsctn.api.exception.DatasourceContainerException;
import com.holly.unit.dsctn.api.exception.enums.DatasourceContainerExceptionEnum;
import com.holly.unit.dsctn.context.DataSourceContext;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class DataSourceInitListener
extends ContextInitializedListener
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(DataSourceInitListener.class);

    public int getOrder() {
        return -2147483448;
    }

    public void eventCallback(ApplicationContextInitializedEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        String dataSourceDriver = environment.getProperty("spring.datasource.driver-class-name");
        String dataSourceUrl = environment.getProperty("spring.datasource.url");
        String dataSourceUsername = environment.getProperty("spring.datasource.username");
        String dataSourcePassword = environment.getProperty("spring.datasource.password");
        if (ObjectUtil.hasEmpty((Object[])new Object[]{dataSourceUrl, dataSourceUsername, dataSourcePassword})) {
            String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.DB_CONNECTION_INFO_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{dataSourceUrl, dataSourceUsername});
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.DB_CONNECTION_INFO_EMPTY_ERROR, new Object[]{userTip});
        }
        DruidProperties druidProperties = new DruidProperties();
        druidProperties.setDriverClassName(dataSourceDriver);
        druidProperties.setUrl(dataSourceUrl);
        druidProperties.setUsername(dataSourceUsername);
        druidProperties.setPassword(dataSourcePassword);
        DruidDataSource druidDataSource = DruidDatasourceFactory.createDruidDataSource((DruidProperties)druidProperties);
        try {
            DataSourceContext.initDataSource(druidProperties, (DataSource)druidDataSource);
        }
        catch (Exception exception) {
            log.error("\u521d\u59cb\u5316\u6570\u636e\u6e90\u5bb9\u5668\u9519\u8bef!", (Throwable)exception);
            String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.INIT_DATASOURCE_CONTAINER_ERROR.getUserTip(), (Object[])new Object[]{exception.getMessage()});
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.INIT_DATASOURCE_CONTAINER_ERROR, new Object[]{userTip});
        }
    }
}

