package com.holly.unit.file.starter;

import com.holly.unit.file.api.FileOperatorApi;
import com.holly.unit.file.api.expander.FileConfigExpander;
import com.holly.unit.file.api.pojo.props.MinIoProperties;
import com.holly.unit.file.minio.MinIoFileOperator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 文件的自动配置
 *
 * @author holly
 * @date 2020/12/1 14:34
 */
@Configuration
public class HollyFileAutoConfiguration {

    /**
     * 本地文件操作
     *
     * @author holly
     * @date 2020/12/1 14:40
     */
    @Bean
    @ConditionalOnMissingBean(FileOperatorApi.class)
    public FileOperatorApi fileOperatorApi() {

//文件保存本地
//        LocalFileProperties localFileProperties = new LocalFileProperties();
//        // 从系统配置表中读取配置
//        localFileProperties.setLocalFileSavePathLinux(FileConfigExpander.getLocalFileSavePathLinux());
//        localFileProperties.setLocalFileSavePathWin(FileConfigExpander.getLocalFileSavePathWindows());
//        return new LocalFileOperator(localFileProperties);
//文件保存到mino
        MinIoProperties minIoProperties=new MinIoProperties();
        minIoProperties.setEndpoint(FileConfigExpander.getMinIoEndpoint());
        minIoProperties.setAccessKey(FileConfigExpander.getMinIoAccessKey());
        minIoProperties.setSecretKey(FileConfigExpander.getMinIoSecretKey());
        return  new MinIoFileOperator(minIoProperties);

    }

}
