package com.holly.unit.security.captcha;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.holly.unit.cache.api.CacheOperatorApi;
import com.holly.unit.security.api.ImageCaptchaApi;
import com.holly.unit.security.api.pojo.ImageCaptcha;
import com.wf.captcha.SpecCaptcha;

/**
 * 图形验证码实现
 *
 * @author holly
 * @date 2021/1/15 13:44
 */
public class ImageCaptchaService implements ImageCaptchaApi {

    private final CacheOperatorApi<String> cacheOperatorApi;

    public ImageCaptchaService(CacheOperatorApi<String> cacheOperatorApi) {
        this.cacheOperatorApi = cacheOperatorApi;
    }

    @Override
    public ImageCaptcha captcha() {
        SpecCaptcha specCaptcha = new SpecCaptcha(130, 48, 4);
        String verCode = specCaptcha.text().toLowerCase();
        String verKey = IdUtil.simpleUUID();
        //缓存三分钟过期
        cacheOperatorApi.put(verKey, verCode,6*60L);
        return ImageCaptcha.builder().verImage(specCaptcha.toBase64()).verKey(verKey).build();
    }

    @Override
    public boolean validateCaptcha(String verKey, String verCode) {
        if (StrUtil.isAllEmpty(verKey, verCode)) {
            return false;
        }

        //验证码过期验证

        if (!verCode.trim().toLowerCase().equals(cacheOperatorApi.get(verKey))) {
            return false;
        }

        //删除缓存中验证码
        //cacheOperatorApi.remove(verKey);

        return true;
    }

    @Override
    public String getVerCode(String verKey) {
        return cacheOperatorApi.get(verKey);
    }

}
