/*
 * Decompiled with CFR 0.152.
 */
package com.holly.unit.security.starter;

import com.holly.unit.cache.api.CacheOperatorApi;
import com.holly.unit.cache.redis.util.CreateRedisTemplateUtil;
import com.holly.unit.security.api.DragCaptchaApi;
import com.holly.unit.security.api.ImageCaptchaApi;
import com.holly.unit.security.captcha.DragCaptchaService;
import com.holly.unit.security.captcha.ImageCaptchaService;
import com.holly.unit.security.captcha.cache.CaptchaRedisCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class CaptchaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ImageCaptchaApi.class})
    public ImageCaptchaApi captchaApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisCache = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        CaptchaRedisCache captchaRedisCache = new CaptchaRedisCache(redisCache);
        return new ImageCaptchaService((CacheOperatorApi)captchaRedisCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={DragCaptchaApi.class})
    public DragCaptchaApi dragCaptchaService(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisCache = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        CaptchaRedisCache captchaRedisCache = new CaptchaRedisCache(redisCache);
        return new DragCaptchaService((CacheOperatorApi)captchaRedisCache);
    }
}

