/*
 * Decompiled with CFR 0.152.
 */
package com.holly.unit.security.starter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import com.holly.unit.cache.api.CacheOperatorApi;
import com.holly.unit.cache.api.constants.CacheConstants;
import com.holly.unit.cache.redis.util.CreateRedisTemplateUtil;
import com.holly.unit.security.api.BlackListApi;
import com.holly.unit.security.api.CountValidatorApi;
import com.holly.unit.security.api.WhiteListApi;
import com.holly.unit.security.blackwhite.BlackListService;
import com.holly.unit.security.blackwhite.WhiteListService;
import com.holly.unit.security.blackwhite.cache.BlackListRedisCache;
import com.holly.unit.security.blackwhite.cache.WhiteListRedisCache;
import com.holly.unit.security.count.DefaultCountValidator;
import com.holly.unit.security.count.cache.DefaultCountValidateCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class CounterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CountValidatorApi.class})
    public CountValidatorApi countValidatorApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        DefaultCountValidateCache defaultCountValidateCache = new DefaultCountValidateCache(timedCache);
        return new DefaultCountValidator((CacheOperatorApi)defaultCountValidateCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlackListApi.class})
    public BlackListApi blackListApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisCache = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        BlackListRedisCache blackListRedisCache = new BlackListRedisCache(redisCache);
        return new BlackListService((CacheOperatorApi)blackListRedisCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={WhiteListApi.class})
    public WhiteListApi whiteListApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisCache = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        WhiteListRedisCache whiteListRedisCache = new WhiteListRedisCache(redisCache);
        return new WhiteListService((CacheOperatorApi)whiteListRedisCache);
    }
}

