/*
 * Decompiled with CFR 0.152.
 */
package com.holly.unit.security.starter;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.holly.unit.security.api.expander.SecurityConfigExpander;
import com.holly.unit.security.xss.XssFilter;
import com.holly.unit.security.xss.XssJacksonDeserializer;
import com.holly.unit.security.xss.prop.XssProperties;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HollyXssAutoConfiguration {
    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterFilterRegistrationBean() {
        XssProperties properties = this.createProperties();
        FilterRegistrationBean xssFilterFilterRegistrationBean = new FilterRegistrationBean();
        xssFilterFilterRegistrationBean.setFilter((Filter)new XssFilter(properties));
        xssFilterFilterRegistrationBean.addUrlPatterns(properties.getUrlPatterns());
        xssFilterFilterRegistrationBean.setName("HOLLY_XSS_FILTER");
        xssFilterFilterRegistrationBean.setOrder(Integer.MIN_VALUE);
        return xssFilterFilterRegistrationBean;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssJackson2ObjectMapperBuilderCustomizer() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.deserializerByType(String.class, (JsonDeserializer)new XssJacksonDeserializer(this.createProperties()));
    }

    private XssProperties createProperties() {
        XssProperties xssProperties = new XssProperties();
        xssProperties.setUrlPatterns(SecurityConfigExpander.getUrlPatterns());
        xssProperties.setUrlExclusion(SecurityConfigExpander.getUrlExclusion());
        return xssProperties;
    }
}

