package com.holly.unit.sms.starter;

import com.holly.unit.sms.aliyun.AliyunSmsSender;
import com.holly.unit.sms.aliyun.msign.impl.MapBasedMultiSignManager;
import com.holly.unit.sms.api.SmsSenderApi;
import com.holly.unit.sms.api.expander.SmsConfigExpander;
import com.holly.unit.sms.api.pojo.AliyunSmsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 短信的自动配置类
 *
 * @author holly
 * @date 2020/12/1 21:18
 */
@Configuration
public class HollySmsAutoConfiguration {

    /**
     * 短信发送器的配置
     *
     * @author holly
     * @date 2020/12/1 21:18
     */
    @Bean
    @ConditionalOnMissingBean(SmsSenderApi.class)
    public SmsSenderApi smsSenderApi() {

        AliyunSmsProperties aliyunSmsProperties = new AliyunSmsProperties();

        // 配置默认从系统配置表读取
        aliyunSmsProperties.setAccessKeyId(SmsConfigExpander.getAliyunSmsAccessKeyId());
        aliyunSmsProperties.setAccessKeySecret(SmsConfigExpander.getAliyunSmsAccessKeySecret());
        aliyunSmsProperties.setSignName(SmsConfigExpander.getAliyunSmsSignName());

        return new AliyunSmsSender(new MapBasedMultiSignManager(), aliyunSmsProperties);
    }

}
