package com.holly.unit.system.starter;

import com.holly.unit.cache.api.CacheOperatorApi;
import com.holly.unit.cache.redis.util.CreateRedisTemplateUtil;
import com.holly.unit.scanner.api.pojo.resource.ResourceDefinition;
import com.holly.unit.system.modular.resource.cache.RedisResourceCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * 资源缓存自动配置
 *
 * @author holly
 * @date 2021/5/17 16:44
 */
@Configuration
public class HollyResourceCacheAutoConfiguration {

//    /**
//     * 资源缓存
//     *
//     * @author holly
//     * @date 2021/5/17 16:44
//     */
//    @Bean
//    @ConditionalOnMissingBean(name = "resourceCache")
//    public CacheOperatorApi<ResourceDefinition> resourceCache() {
//        TimedCache<String, ResourceDefinition> timedCache = CacheUtil.newTimedCache(CacheConstants.NONE_EXPIRED_TIME);
//        return new MemoryResourceCache(timedCache);
//    }

    /**
     * 资源缓存
     *
     * @author holly
     * @date 2021/5/17 16:44
     */
    @Bean
    @ConditionalOnMissingBean(name = "resourceCache")
    public CacheOperatorApi<ResourceDefinition> resourceCache(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, ResourceDefinition> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new RedisResourceCache(redisCache);
    }
}
