package com.holly.unit.system.starter;

import com.holly.unit.cache.api.CacheOperatorApi;
import com.holly.unit.cache.redis.util.CreateRedisTemplateUtil;
import com.holly.unit.system.api.pojo.user.HisUserPasswordDTO;
import com.holly.unit.system.api.pojo.user.SysUserDTO;
import com.holly.unit.system.api.pojo.user.SysUserOrgDTO;
import com.holly.unit.system.modular.role.cache.RoleDataScopeRedisCache;
import com.holly.unit.system.modular.role.cache.RoleRedisCache;
import com.holly.unit.system.modular.role.cache.RoleResourceRedisCache;
import com.holly.unit.system.modular.role.entity.SysRole;
import com.holly.unit.system.modular.user.cache.*;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.List;

/**
 * 系统管理缓存的自动配置（默认内存缓存）
 *
 * @author holly
 * @date 2021/2/28 10:29
 */
@Configuration
public class HollySystemCacheAutoConfiguration {

//    /**
//     * 用户的缓存，非在线用户缓存，此缓存为了加快查看用户相关操作
//     *
//     * @author holly
//     * @date 2021/2/28 10:30
//     */
//    @Bean
//    @ConditionalOnMissingBean(name = "sysUserCacheOperatorApi")
//    public CacheOperatorApi<SysUserDTO> sysUserCacheOperatorApi() {
//        TimedCache<String, SysUserDTO> sysUserTimedCache = CacheUtil.newTimedCache(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000);
//        return new SysUserMemoryCache(sysUserTimedCache);
//    }
//
//    /**
//     * 用户角色对应的缓存
//     *
//     * @author holly
//     * @date 2021/7/29 23:00
//     */
//    @Bean
//    @ConditionalOnMissingBean(name = "userRoleCacheApi")
//    public CacheOperatorApi<List<Long>> userRoleCacheApi() {
//        TimedCache<String, List<Long>> userRoleCache = CacheUtil.newTimedCache(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000);
//        return new UserRoleMemoryCache(userRoleCache);
//    }
//
//    /**
//     * 角色信息对应的缓存
//     *
//     * @author holly
//     * @date 2021/7/29 23:00
//     */
//    @Bean
//    @ConditionalOnMissingBean(name = "roleInfoCacheApi")
//    public CacheOperatorApi<SysRole> roleInfoCacheApi() {
//        TimedCache<String, SysRole> roleCache = CacheUtil.newTimedCache(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000);
//        return new RoleMemoryCache(roleCache);
//    }
//
//    /**
//     * 用户组织机构的缓存
//     *
//     * @author holly
//     * @date 2021/7/30 23:09
//     */
//    @Bean
//    @ConditionalOnMissingBean(name = "userOrgCacheApi")
//    public CacheOperatorApi<SysUserOrgDTO> userOrgCacheApi() {
//        TimedCache<String, SysUserOrgDTO> roleCache = CacheUtil.newTimedCache(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000);
//        return new UserOrgMemoryCache(roleCache);
//    }
//
//    /**
//     * 用户资源绑定的缓存
//     *
//     * @author holly
//     * @date 2021/7/30 23:29
//     */
//    @Bean
//    @ConditionalOnMissingBean(name = "roleResourceCacheApi")
//    public CacheOperatorApi<List<String>> roleResourceCacheApi() {
//        TimedCache<String, List<String>> roleCache = CacheUtil.newTimedCache(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000);
//        return new RoleResourceMemoryCache(roleCache);
//    }
//
//    /**
//     * 角色绑定的数据范围的缓存
//     *
//     * @author holly
//     * @date 2021/7/31 17:59
//     */
//    @Bean
//    @ConditionalOnMissingBean(name = "roleDataScopeCacheApi")
//    public CacheOperatorApi<List<Long>> roleDataScopeCacheApi() {
//        TimedCache<String, List<Long>> roleCache = CacheUtil.newTimedCache(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000);
//        return new RoleDataScopeMemoryCache(roleCache);
//    }

    /**
     * 用户的缓存，非在线用户缓存，此缓存为了加快查看用户相关操作
     *
     * @author holly
     * @date 2021/2/28 10:30
     */
    @Bean
    @ConditionalOnMissingBean(name = "sysUserCacheOperatorApi")
    public CacheOperatorApi<SysUserDTO> sysUserCacheOperatorApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, SysUserDTO> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new SysUserRedisCache(redisCache);
    }

    /**
     * 用户角色对应的缓存
     *
     * @author holly
     * @date 2021/7/29 23:00
     */
    @Bean
    @ConditionalOnMissingBean(name = "userRoleCacheApi")
    public CacheOperatorApi<List<Long>> userRoleCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, List<Long>> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new UserRoleRedisCache(redisCache);
    }

    /**
     * 角色信息对应的缓存
     *
     * @author holly
     * @date 2021/7/29 23:00
     */
    @Bean
    @ConditionalOnMissingBean(name = "roleInfoCacheApi")
    public CacheOperatorApi<SysRole> roleInfoCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, SysRole> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new RoleRedisCache(redisCache);
    }

    /**
     * 用户组织机构的缓存
     *
     * @author holly
     * @date 2021/7/30 23:09
     */
    @Bean
    @ConditionalOnMissingBean(name = "userOrgCacheApi")
    public CacheOperatorApi<SysUserOrgDTO> userOrgCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, SysUserOrgDTO> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new UserOrgRedisCache(redisCache);
    }

    /**
     * 用户角色对应的缓存
     *
     * @author holly
     * @date 2021/7/29 23:00
     */
    @Bean
    @ConditionalOnMissingBean(name = "cacheHisPassWordApi")
    public CacheOperatorApi<HisUserPasswordDTO> cacheHisPassWordApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, HisUserPasswordDTO> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new SysHisPasswordCache(redisCache);
    }
    /**
     * 用户角色对应的缓存
     *
     * @author holly
     * @date 2021/7/29 23:00
     */
    @Bean
    @ConditionalOnMissingBean(name = "cachePasswordLockedApi")
    public CacheOperatorApi<Long> cachePasswordLockedApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, Long> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new SysLoginLockedCache(redisCache);
    }
    /**
     * 用户资源绑定的缓存
     *
     * @author holly
     * @date 2021/7/30 23:29
     */
    @Bean
    @ConditionalOnMissingBean(name = "roleResourceCacheApi")
    public CacheOperatorApi<List<String>> roleResourceCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, List<String>> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new RoleResourceRedisCache(redisCache);
    }

    /**
     * 角色绑定的数据范围的缓存
     *
     * @author holly
     * @date 2021/7/31 17:59
     */
    @Bean
    @ConditionalOnMissingBean(name = "roleDataScopeCacheApi")
    public CacheOperatorApi<List<Long>> roleDataScopeCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, List<Long>> redisCache = CreateRedisTemplateUtil.createObject(redisConnectionFactory);
        return new RoleDataScopeRedisCache(redisCache);
    }
}
