/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.config;

import com.querydsl.jpa.impl.JPAQueryFactory;
import io.gitee.lshaci.scmsaext.datapermission.config.SysDpClearCacheAspect;
import io.gitee.lshaci.scmsaext.datapermission.exception.SysDpExceptionHandler;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpTableHelper;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpUserResourceHelper;
import io.gitee.lshaci.scmsaext.datapermission.helper.impl.SysDpTableHelperImpl;
import io.gitee.lshaci.scmsaext.datapermission.helper.impl.SysDpUserResourceHelperImpl;
import io.gitee.lshaci.scmsaext.datapermission.properties.SysDpProperties;
import io.gitee.lshaci.scmsaext.datapermission.util.SysDpUtil;
import io.gitee.lshaci.scmsaext.jpa.dsl.EnableDslQuery;
import javax.persistence.EntityManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableDslQuery
@EnableJpaAuditing
@EnableConfigurationProperties(value={SysDpProperties.class})
@EntityScan(value={"io.gitee.lshaci.scmsaext.datapermission.entity"})
@ComponentScan(value={"io.gitee.lshaci.scmsaext.datapermission.service", "io.gitee.lshaci.scmsaext.datapermission.controller"})
@EnableJpaRepositories(value={"io.gitee.lshaci.scmsaext.datapermission.repository"})
public class SysDpConfiguration {
    private final SysDpProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public JPAQueryFactory jpaQueryFactory(EntityManager entityManager) {
        return new JPAQueryFactory(entityManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public SysDpExceptionHandler sysDpExceptionHandler() {
        return new SysDpExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public SysDpTableHelper sysDpTableHelper() {
        return new SysDpTableHelperImpl(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public SysDpUserResourceHelper sysDpUserResourceHelper() {
        return new SysDpUserResourceHelperImpl(this.properties);
    }

    @Bean
    public SysDpClearCacheAspect sysDpClearCacheAspect() {
        return new SysDpClearCacheAspect();
    }

    @Bean
    public SysDpUtil sysDpUtil() {
        return new SysDpUtil();
    }

    public SysDpConfiguration(SysDpProperties properties) {
        this.properties = properties;
    }
}

