/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.controller;

import io.gitee.lshaci.scmsaext.common.model.JsonPageResult;
import io.gitee.lshaci.scmsaext.common.model.JsonResult;
import io.gitee.lshaci.scmsaext.common.model.LabelValue;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpClearCache;
import io.gitee.lshaci.scmsaext.datapermission.enums.ColumnType;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpColumnAddDto;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpColumnUpdateDto;
import io.gitee.lshaci.scmsaext.datapermission.model.qo.SysDpColumnQo;
import io.gitee.lshaci.scmsaext.datapermission.model.vo.SysDpColumnVo;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpColumnService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scmsaext/sysdp/column"})
public class SysDpColumnController {
    private final SysDpColumnService sysDpColumnService;

    @GetMapping(value={"/type"})
    public JsonResult<List<LabelValue>> type() {
        List data = Arrays.stream(ColumnType.values()).map(ct -> LabelValue.of((String)ct.getLabel(), (Object)ct.name())).collect(Collectors.toList());
        return JsonResult.success(data);
    }

    @SysDpClearCache
    @PostMapping(value={"/add"})
    public JsonResult<Object> add(@Valid @RequestBody SysDpColumnAddDto dto) {
        this.sysDpColumnService.add(dto);
        return JsonResult.success((Object)"\u6dfb\u52a0\u5217\u4fe1\u606f\u6210\u529f");
    }

    @SysDpClearCache
    @PostMapping(value={"/del/{id}"})
    public JsonResult<Object> del(@PathVariable String id) {
        this.sysDpColumnService.del(id);
        return JsonResult.success((Object)"\u5220\u9664\u5217\u4fe1\u606f\u6210\u529f");
    }

    @SysDpClearCache
    @PostMapping(value={"/update"})
    public JsonResult<Object> update(@Valid @RequestBody SysDpColumnUpdateDto dto) {
        this.sysDpColumnService.update(dto);
        return JsonResult.success((Object)"\u4fee\u6539\u5217\u4fe1\u606f\u6210\u529f");
    }

    @PostMapping(value={"/list"})
    public JsonPageResult<List<SysDpColumnVo>> list(@Valid @RequestBody SysDpColumnQo qo) {
        return this.sysDpColumnService.pageByQuery2Vo(qo);
    }

    public SysDpColumnController(SysDpColumnService sysDpColumnService) {
        this.sysDpColumnService = sysDpColumnService;
    }
}

