/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.controller;

import io.gitee.lshaci.scmsaext.common.model.JsonPageResult;
import io.gitee.lshaci.scmsaext.common.model.JsonResult;
import io.gitee.lshaci.scmsaext.common.valid.group.DeleteGroup;
import io.gitee.lshaci.scmsaext.common.valid.group.InsertGroup;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpClearCache;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpTableHelper;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpUserResourceHelper;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpConfigDto;
import io.gitee.lshaci.scmsaext.datapermission.model.qo.SysDpConfigQo;
import io.gitee.lshaci.scmsaext.datapermission.model.vo.SysDpConfigVo;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpConfigService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scmsaext/sysdp/config"})
public class SysDpConfigController {
    private final SysDpTableHelper sysDpTableHelper;
    private final SysDpUserResourceHelper sysDpUserResourceHelper;
    private final SysDpConfigService sysDpConfigService;

    @SysDpClearCache
    @PostMapping(value={"/setup"})
    public JsonResult<Object> setup(@Valid @RequestBody SysDpConfigDto dto) {
        this.sysDpConfigService.setup(dto);
        return JsonResult.success((Object)"\u8bbe\u7f6e\u8d44\u6e90\u6210\u529f");
    }

    @SysDpClearCache
    @PostMapping(value={"/authorize"})
    public JsonResult<Object> authorize(@Validated(value={InsertGroup.class}) @RequestBody SysDpConfigDto dto) {
        this.sysDpConfigService.authorize(dto);
        return JsonResult.success((Object)"\u6dfb\u52a0\u8d44\u6e90\u6210\u529f");
    }

    @SysDpClearCache
    @PostMapping(value={"/cancel"})
    public JsonResult<Object> cancel(@Validated(value={DeleteGroup.class}) @RequestBody SysDpConfigDto dto) {
        this.sysDpConfigService.cancel(dto);
        return JsonResult.success((Object)"\u5220\u9664\u8d44\u6e90\u6210\u529f");
    }

    @SysDpClearCache
    @PostMapping(value={"/delAll"})
    public JsonResult<Object> delAll(@Valid @RequestBody SysDpConfigDto dto) {
        this.sysDpConfigService.delAll(dto.getOwnerType(), dto.getOwner());
        return JsonResult.success((Object)"\u5220\u9664\u6240\u6709\u8d44\u6e90\u6210\u529f");
    }

    @PostMapping(value={"/list"})
    public JsonPageResult<List<SysDpConfigVo>> list(@Valid @RequestBody SysDpConfigQo qo) {
        return this.sysDpConfigService.pageByQuery2Vo(qo);
    }

    public SysDpConfigController(SysDpTableHelper sysDpTableHelper, SysDpUserResourceHelper sysDpUserResourceHelper, SysDpConfigService sysDpConfigService) {
        this.sysDpTableHelper = sysDpTableHelper;
        this.sysDpUserResourceHelper = sysDpUserResourceHelper;
        this.sysDpConfigService = sysDpConfigService;
    }
}

