/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.controller;

import io.gitee.lshaci.scmsaext.common.model.JsonPageResult;
import io.gitee.lshaci.scmsaext.common.model.JsonResult;
import io.gitee.lshaci.scmsaext.common.model.LabelValue;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpClearCache;
import io.gitee.lshaci.scmsaext.datapermission.enums.MatchType;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpResourceAddDto;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpResourceUpdateDto;
import io.gitee.lshaci.scmsaext.datapermission.model.qo.SysDpResourceQo;
import io.gitee.lshaci.scmsaext.datapermission.model.vo.SysDpResourceVo;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpResourceService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scmsaext/sysdp/resource"})
public class SysDpResourceController {
    private final SysDpResourceService sysDpResourceService;

    @GetMapping(value={"/matchType"})
    public JsonResult<List<LabelValue>> matchType() {
        List data = Arrays.stream(MatchType.values()).map(mt -> LabelValue.of((String)mt.getLabel(), (Object)mt.name())).collect(Collectors.toList());
        return JsonResult.success(data);
    }

    @PostMapping(value={"/add"})
    public JsonResult<Object> add(@Valid @RequestBody SysDpResourceAddDto dto) {
        this.sysDpResourceService.add(dto);
        return JsonResult.success((Object)"\u6dfb\u52a0\u8d44\u6e90\u6210\u529f");
    }

    @PostMapping(value={"/del/{id}"})
    public JsonResult<Object> del(@PathVariable String id) {
        this.sysDpResourceService.del(id);
        return JsonResult.success((Object)"\u5220\u9664\u8d44\u6e90\u6210\u529f");
    }

    @SysDpClearCache
    @PostMapping(value={"/update"})
    public JsonResult<Object> update(@Valid @RequestBody SysDpResourceUpdateDto dto) {
        this.sysDpResourceService.update(dto);
        return JsonResult.success((Object)"\u4fee\u6539\u8d44\u6e90\u6210\u529f");
    }

    @PostMapping(value={"/list"})
    public JsonPageResult<List<SysDpResourceVo>> list(@RequestBody SysDpResourceQo qo) {
        return this.sysDpResourceService.pageByQuery2Vo(qo);
    }

    public SysDpResourceController(SysDpResourceService sysDpResourceService) {
        this.sysDpResourceService = sysDpResourceService;
    }
}

