/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.enums;

import cn.hutool.core.collection.CollUtil;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;

public enum MatchType {
    EQ("\u7b49\u4e8e"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new EqualsTo((Expression)column, func.apply(value.get(0)));
        }
    }
    ,
    NE("\u4e0d\u7b49\u4e8e"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new NotEqualsTo((Expression)column, func.apply(value.get(0)));
        }
    }
    ,
    LT("\u5c0f\u4e8e"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new MinorThan().withLeftExpression((Expression)column).withRightExpression(func.apply(value.get(0)));
        }
    }
    ,
    LE("\u5c0f\u4e8e\u7b49\u4e8e"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new MinorThanEquals().withLeftExpression((Expression)column).withRightExpression(func.apply(value.get(0)));
        }
    }
    ,
    GT("\u5927\u4e8e"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new GreaterThan().withLeftExpression((Expression)column).withRightExpression(func.apply(value.get(0)));
        }
    }
    ,
    GE("\u5927\u4e8e\u7b49\u4e8e"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new GreaterThanEquals().withLeftExpression((Expression)column).withRightExpression(func.apply(value.get(0)));
        }
    }
    ,
    CO("\u5305\u542b"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new LikeExpression().withLeftExpression((Expression)column).withRightExpression((Expression)new StringValue("%" + value.get(0) + "%"));
        }
    }
    ,
    NC("\u4e0d\u5305\u542b"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new LikeExpression().withNot(true).withLeftExpression((Expression)column).withRightExpression((Expression)new StringValue("%" + value.get(0) + "%"));
        }
    }
    ,
    SW("\u5f00\u59cb\u4ee5"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new LikeExpression().withLeftExpression((Expression)column).withRightExpression((Expression)new StringValue(value.get(0) + "%"));
        }
    }
    ,
    EW("\u7ed3\u675f\u4ee5"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            return new LikeExpression().withLeftExpression((Expression)column).withRightExpression((Expression)new StringValue("%" + value.get(0)));
        }
    }
    ,
    IN("\u5728\u5217\u8868\u4e2d"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            if (value.size() == 1) {
                return EQ.doAccept(column, func, value);
            }
            List values = value.stream().map(func).collect(Collectors.toList());
            return new InExpression().withLeftExpression((Expression)column).withRightItemsList((ItemsList)new ExpressionList(values));
        }
    }
    ,
    NI("\u4e0d\u5728\u5217\u8868\u4e2d"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            if (value.size() == 1) {
                return NE.doAccept(column, func, value);
            }
            List values = value.stream().map(func).collect(Collectors.toList());
            return new InExpression().withNot(true).withLeftExpression((Expression)column).withRightItemsList((ItemsList)new ExpressionList(values));
        }
    }
    ,
    BT("\u5728\u8303\u56f4\u5185"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            if (value.size() == 1) {
                return GE.doAccept(column, func, value);
            }
            return new Between().withLeftExpression((Expression)column).withBetweenExpressionStart(func.apply(value.get(0))).withBetweenExpressionEnd(func.apply(value.get(1)));
        }
    }
    ,
    NB("\u4e0d\u5728\u8303\u56f4\u5185"){

        @Override
        protected Expression doAccept(Column column, Function<String, Expression> func, List<String> value) {
            if (value.size() == 1) {
                return LT.doAccept(column, func, value);
            }
            return new Between().withNot(true).withLeftExpression((Expression)column).withBetweenExpressionStart(func.apply(value.get(0))).withBetweenExpressionEnd(func.apply(value.get(1)));
        }
    };

    private final String label;

    public Expression accept(Column column, Function<String, Expression> func, List<String> value) {
        if (CollUtil.isEmpty(value)) {
            return new EqualsTo((Expression)column, null);
        }
        return this.doAccept(column, func, value);
    }

    protected abstract Expression doAccept(Column var1, Function<String, Expression> var2, List<String> var3);

    public String getLabel() {
        return this.label;
    }

    private MatchType(String label) {
        this.label = label;
    }
}

