/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.helper.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpTableHelper;
import io.gitee.lshaci.scmsaext.datapermission.properties.SysDpCacheInfo;
import io.gitee.lshaci.scmsaext.datapermission.properties.SysDpProperties;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpTableRepository;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

public class SysDpTableHelperImpl
implements SysDpTableHelper {
    private static final Set<String> EXCLUDE_TABLE_CACHE = new HashSet<String>();
    private final TimedCache<String, Boolean> TABLE_CACHE;
    private final TimedCache<String, SysDpTable> CACHE_TABLE;
    private final SysDpProperties properties;
    private final boolean updateLastAccess;
    @Autowired
    private SysDpTableRepository sysDpTableRepository;

    public SysDpTableHelperImpl(SysDpProperties properties) {
        this.properties = properties;
        SysDpCacheInfo cacheInfo = properties.getCache();
        long millis = cacheInfo.getTimeout().toMillis();
        this.updateLastAccess = cacheInfo.isUpdateLastAccess();
        this.TABLE_CACHE = CacheUtil.newTimedCache((long)millis);
        this.CACHE_TABLE = CacheUtil.newTimedCache((long)millis);
    }

    @Override
    public boolean isEnable() {
        return this.properties.isEnable();
    }

    @Override
    public void clearCache() {
        this.TABLE_CACHE.clear();
        this.CACHE_TABLE.clear();
    }

    @Override
    public boolean noResourcePermitAll() {
        return this.properties.isNoResourcePermitAll();
    }

    @Override
    public boolean isSysDpTable(String tableName) {
        return "sys_dp_table".equalsIgnoreCase(tableName) || "sys_dp_column".equalsIgnoreCase(tableName) || "sys_dp_option".equalsIgnoreCase(tableName) || "sys_dp_resource".equalsIgnoreCase(tableName) || "sys_dp_config".equalsIgnoreCase(tableName);
    }

    @Override
    public boolean isExcludeTable(String tableName) {
        if (EXCLUDE_TABLE_CACHE.contains(tableName)) {
            return true;
        }
        List<String> excludeTableList = this.properties.excludeTable();
        if (CollUtil.isEmpty(excludeTableList)) {
            return false;
        }
        for (String excludeTable : excludeTableList) {
            if (StrUtil.equals((CharSequence)tableName, (CharSequence)excludeTable)) {
                EXCLUDE_TABLE_CACHE.add(tableName);
                return true;
            }
            Pattern pattern = Pattern.compile(excludeTable);
            if (!pattern.matcher(tableName).matches()) continue;
            EXCLUDE_TABLE_CACHE.add(tableName);
            return true;
        }
        return false;
    }

    @Override
    public SysDpTable isResourceTable(String tableName) {
        Boolean b = (Boolean)this.TABLE_CACHE.get((Object)tableName, this.updateLastAccess);
        if (b == null) {
            return this.cacheResourceTable(tableName);
        }
        if (!b.booleanValue()) {
            return null;
        }
        SysDpTable sysDpTable = (SysDpTable)this.CACHE_TABLE.get((Object)tableName, this.updateLastAccess);
        return sysDpTable != null ? sysDpTable : this.cacheResourceTable(tableName);
    }

    private SysDpTable cacheResourceTable(String tableName) {
        Optional<SysDpTable> sysDpTableOptional = this.sysDpTableRepository.findByTableName(tableName);
        if (sysDpTableOptional.isPresent()) {
            SysDpTable sysDpTable = sysDpTableOptional.get();
            this.TABLE_CACHE.put((Object)tableName, (Object)true);
            this.CACHE_TABLE.put((Object)tableName, (Object)sysDpTable);
            return sysDpTable;
        }
        this.TABLE_CACHE.put((Object)tableName, (Object)false);
        return null;
    }
}

