/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.helper.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpBaseEntity;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpUserService;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpValueService;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpConfig;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpResource;
import io.gitee.lshaci.scmsaext.datapermission.enums.OptionValueSource;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpUserResourceHelper;
import io.gitee.lshaci.scmsaext.datapermission.model.bo.SysDpResourceBo;
import io.gitee.lshaci.scmsaext.datapermission.properties.SysDpCacheInfo;
import io.gitee.lshaci.scmsaext.datapermission.properties.SysDpProperties;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpOptionRepository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import org.springframework.beans.factory.annotation.Autowired;

public class SysDpUserResourceHelperImpl
implements SysDpUserResourceHelper {
    @Autowired
    protected JPAQueryFactory jpaQueryFactory;
    @Autowired
    protected SysDpUserService sysDpUserService;
    @Autowired
    protected SysDpOptionRepository sysDpOptionRepository;
    protected final TimedCache<String, Boolean> USER_HAS_TABLE_RESOURCE;
    protected final TimedCache<String, List<Expression>> USER_TABLE_RESOURCE;
    protected final boolean updateLastAccess;

    public SysDpUserResourceHelperImpl(SysDpProperties properties) {
        SysDpCacheInfo cacheInfo = properties.getCache();
        long millis = cacheInfo.getTimeout().toMillis();
        this.updateLastAccess = cacheInfo.isUpdateLastAccess();
        this.USER_HAS_TABLE_RESOURCE = CacheUtil.newTimedCache((long)millis);
        this.USER_TABLE_RESOURCE = CacheUtil.newTimedCache((long)millis);
    }

    @Override
    public void clearCache() {
        this.USER_HAS_TABLE_RESOURCE.clear();
        this.USER_TABLE_RESOURCE.clear();
    }

    @Override
    public List<Expression> userResource(String tableId, Table table) {
        String user = this.sysDpUserService.user();
        if (StrUtil.isBlank((CharSequence)user)) {
            return null;
        }
        String key = user + "::" + tableId + "::" + this.getTableAlias(table);
        Boolean b = (Boolean)this.USER_HAS_TABLE_RESOURCE.get((Object)key, this.updateLastAccess);
        if (b == null) {
            return this.cacheUserResource(key, tableId, table);
        }
        if (!b.booleanValue()) {
            return null;
        }
        List<Expression> sysDpTable = (List<Expression>)this.USER_TABLE_RESOURCE.get((Object)key, this.updateLastAccess);
        return sysDpTable != null ? sysDpTable : this.cacheUserResource(key, tableId, table);
    }

    private String getTableAlias(Table table) {
        if (table == null) {
            return "";
        }
        if (table.getAlias() != null) {
            return table.getAlias().getName();
        }
        return table.getFullyQualifiedName();
    }

    private List<Expression> cacheUserResource(String key, String tableId, Table table) {
        List<SysDpResourceBo> userResource = this.fetchUserResource(tableId);
        if (CollUtil.isEmpty(userResource)) {
            this.USER_HAS_TABLE_RESOURCE.put((Object)key, (Object)false);
            return null;
        }
        List<Expression> expressions = this.parseUserResource(userResource, table);
        this.USER_HAS_TABLE_RESOURCE.put((Object)key, (Object)true);
        this.USER_TABLE_RESOURCE.put((Object)key, expressions);
        return expressions;
    }

    private List<Expression> parseUserResource(List<SysDpResourceBo> userResource, Table table) {
        List<String> optionIdList = userResource.stream().flatMap(SysDpResourceBo::optionId).collect(Collectors.toList());
        Map<String, List<String>> optionId2ValueMap = this.parseOptionValue(optionIdList);
        return userResource.stream().map(ur -> this.conditionExpression(table, optionId2ValueMap, (SysDpResourceBo)ur)).collect(Collectors.toList());
    }

    private Expression conditionExpression(Table table, Map<String, List<String>> optionId2ValueMap, SysDpResourceBo sysDpResourceBo) {
        List<String> value = sysDpResourceBo.optionId().flatMap(oid -> optionId2ValueMap.getOrDefault(oid, Collections.emptyList()).stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return sysDpResourceBo.getMatchType().accept(sysDpResourceBo.getColumn(table), sysDpResourceBo.getColumnType().getFunc(), value);
    }

    private Map<String, List<String>> parseOptionValue(List<String> optionIdList) {
        return this.sysDpOptionRepository.findAllById(optionIdList).stream().collect(Collectors.toMap(SysDpBaseEntity::getId, sdo -> {
            String optionValue = sdo.getOptionValue();
            OptionValueSource optionValueSource = sdo.getOptionValueSource();
            if (optionValueSource == OptionValueSource.database) {
                return Collections.singletonList(optionValue);
            }
            SysDpValueService valueService = (SysDpValueService)SpringUtil.getBean((String)optionValue, SysDpValueService.class);
            List<String> value = valueService.fetch();
            return CollUtil.isEmpty(value) ? Collections.emptyList() : value;
        }));
    }

    private List<SysDpResourceBo> fetchUserResource(String tableId) {
        String user = this.sysDpUserService.user();
        List<String> role = this.sysDpUserService.role();
        List<String> org = this.sysDpUserService.org();
        QSysDpConfig qSysDpConfig = QSysDpConfig.sysDpConfig;
        QSysDpColumn qSysDpColumn = QSysDpColumn.sysDpColumn;
        QSysDpResource qSysDpResource = QSysDpResource.sysDpResource;
        BooleanExpression tableIdEq = qSysDpColumn.tableId.eq((Object)tableId);
        BooleanExpression userRoleOrg = qSysDpConfig.user.eq((Object)user);
        if (CollUtil.isNotEmpty(role)) {
            userRoleOrg = userRoleOrg.or((Predicate)qSysDpConfig.role.in(role));
        }
        if (CollUtil.isNotEmpty(org)) {
            userRoleOrg = userRoleOrg.or((Predicate)qSysDpConfig.org.in(org));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((com.querydsl.core.types.Expression)Projections.bean(SysDpResourceBo.class, (com.querydsl.core.types.Expression[])new com.querydsl.core.types.Expression[]{qSysDpColumn.columnName.as("columnName"), qSysDpColumn.columnType.as("columnType"), qSysDpResource.matchType.as("matchType"), qSysDpResource.matchValue.as("matchValue")})).distinct()).from((EntityPath)qSysDpConfig)).join((EntityPath)qSysDpResource)).on((Predicate)qSysDpConfig.resourceId.eq((com.querydsl.core.types.Expression)qSysDpResource.id))).join((EntityPath)qSysDpColumn)).on((Predicate)qSysDpResource.columnId.eq((com.querydsl.core.types.Expression)qSysDpColumn.id))).where((Predicate)tableIdEq.and((Predicate)userRoleOrg))).fetch();
    }
}

