/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.properties;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import io.gitee.lshaci.scmsaext.datapermission.properties.SysDpCacheInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="scmsa-ext.data-permission")
public class SysDpProperties {
    private boolean enable = true;
    private String excludeTable;
    private SysDpCacheInfo cache = new SysDpCacheInfo();
    private boolean noResourcePermitAll = true;

    public List<String> excludeTable() {
        if (StrUtil.isBlank((CharSequence)this.excludeTable)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.excludeTable.split(",")).filter(CharSequenceUtil::isNotBlank).map(String::toLowerCase).collect(Collectors.toList());
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getExcludeTable() {
        return this.excludeTable;
    }

    public SysDpCacheInfo getCache() {
        return this.cache;
    }

    public boolean isNoResourcePermitAll() {
        return this.noResourcePermitAll;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setExcludeTable(String excludeTable) {
        this.excludeTable = excludeTable;
    }

    public void setCache(SysDpCacheInfo cache) {
        this.cache = cache;
    }

    public void setNoResourcePermitAll(boolean noResourcePermitAll) {
        this.noResourcePermitAll = noResourcePermitAll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysDpProperties)) {
            return false;
        }
        SysDpProperties other = (SysDpProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isNoResourcePermitAll() != other.isNoResourcePermitAll()) {
            return false;
        }
        String this$excludeTable = this.getExcludeTable();
        String other$excludeTable = other.getExcludeTable();
        if (this$excludeTable == null ? other$excludeTable != null : !this$excludeTable.equals(other$excludeTable)) {
            return false;
        }
        SysDpCacheInfo this$cache = this.getCache();
        SysDpCacheInfo other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysDpProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isNoResourcePermitAll() ? 79 : 97);
        String $excludeTable = this.getExcludeTable();
        result = result * 59 + ($excludeTable == null ? 43 : $excludeTable.hashCode());
        SysDpCacheInfo $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        return result;
    }

    public String toString() {
        return "SysDpProperties(enable=" + this.isEnable() + ", excludeTable=" + this.getExcludeTable() + ", cache=" + this.getCache() + ", noResourcePermitAll=" + this.isNoResourcePermitAll() + ")";
    }
}

