/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpBaseEntity;
import io.gitee.lshaci.scmsaext.datapermission.exception.SysDpException;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpBaseRepository;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpBaseService;
import io.gitee.lshaci.scmsaext.jpa.PageAndSortQuery;
import io.gitee.lshaci.scmsaext.jpa.lambda.LambdaQueryWrapper;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
public abstract class SysDpBaseServiceImpl<T extends SysDpBaseEntity, R extends SysDpBaseRepository<T>>
implements SysDpBaseService<T, R> {
    @Autowired
    protected R baseRepository;
    protected final Log log = LogFactory.get(this.getClass());

    @Override
    public R baseRepository() {
        return this.baseRepository;
    }

    @Override
    public long countWrapper(LambdaQueryWrapper<T> wrapper) {
        return this.baseRepository.count(wrapper);
    }

    @Override
    public List<T> findByWrapper(LambdaQueryWrapper<T> wrapper) {
        return this.baseRepository.findAll(wrapper);
    }

    @Override
    public Optional<T> findOneByWrapper(LambdaQueryWrapper<T> wrapper) {
        List<T> list = this.findByWrapper(wrapper);
        if (CollUtil.isEmpty(list)) {
            return Optional.empty();
        }
        if (list.size() > 1) {
            throw SysDpException.build("\u5e0c\u671b\u67e5\u8be2\u30101\u3011\u6761\u6570\u636e\uff0c\u4f46\u83b7\u53d6\u5230\u3010{}\u3011\u6761", list.size());
        }
        return Optional.of(list.get(0));
    }

    @Override
    public List<T> findByWrapperAndSort(LambdaQueryWrapper<T> wrapper) {
        return this.baseRepository.findAll(wrapper, wrapper.sort());
    }

    @Override
    public Page<T> pageByQuery(LambdaQueryWrapper<T> wrapper) {
        return this.baseRepository.findAll(wrapper, wrapper.pageable());
    }

    @Override
    public long countByQuery(PageAndSortQuery query) {
        return this.baseRepository.count((Specification)query.specification());
    }

    @Override
    public List<T> findByQuery(PageAndSortQuery query) {
        return this.baseRepository.findAll((Specification)query.specification());
    }

    @Override
    public Optional<T> findOneByQuery(PageAndSortQuery query) {
        List<T> list = this.findByQuery(query);
        if (CollUtil.isEmpty(list)) {
            return Optional.empty();
        }
        if (list.size() > 1) {
            throw SysDpException.build("\u5e0c\u671b\u67e5\u8be2\u30101\u3011\u6761\u6570\u636e\uff0c\u4f46\u83b7\u53d6\u5230\u3010{}\u3011\u6761", list.size());
        }
        return Optional.of(list.get(0));
    }

    @Override
    public List<T> findByQueryAndSort(PageAndSortQuery query) {
        return this.baseRepository.findAll((Specification)query.specification(), query.sort());
    }

    @Override
    public Page<T> pageByQuery(PageAndSortQuery query) {
        return this.baseRepository.findAll((Specification)query.specification(), query.pageable());
    }
}

