/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import io.gitee.lshaci.scmsaext.common.model.JsonPageResult;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpBaseEntity;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.exception.SysDpException;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpColumnAddDto;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpColumnUpdateDto;
import io.gitee.lshaci.scmsaext.datapermission.model.qo.SysDpColumnQo;
import io.gitee.lshaci.scmsaext.datapermission.model.vo.SysDpColumnVo;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpColumnRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpConfigRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpOptionRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpResourceRepository;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpColumnService;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpTableService;
import io.gitee.lshaci.scmsaext.datapermission.service.impl.SysDpBaseServiceImpl;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslQuery;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslUtil;
import io.gitee.lshaci.scmsaext.jpa.lambda.LambdaQueryWrapper;
import io.gitee.lshaci.scmsaext.jpa.lambda.Wrappers;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDpColumnServiceImpl
extends SysDpBaseServiceImpl<SysDpColumn, SysDpColumnRepository>
implements SysDpColumnService {
    @Autowired
    private SysDpTableService sysDpTableService;
    @Autowired
    private SysDpOptionRepository sysDpOptionRepository;
    @Autowired
    private SysDpConfigRepository sysDpConfigRepository;
    @Autowired
    private SysDpResourceRepository sysDpResourceRepository;

    @Override
    public SysDpColumn findByIdOrThrow(String id) {
        return (SysDpColumn)((SysDpColumnRepository)this.baseRepository).findById(id).orElseThrow(() -> SysDpException.build("\u5217\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]));
    }

    @Override
    public void add(SysDpColumnAddDto dto) {
        SysDpTable sysDpTable = (SysDpTable)this.sysDpTableService.findByIdOrThrow(dto.getTableId());
        String tableId = sysDpTable.getId();
        this.verifyName(tableId, dto.getColumnName(), null);
        SysDpColumn entity = (SysDpColumn)BeanUtil.copyProperties((Object)dto, SysDpColumn.class, (String[])new String[0]);
        entity.setTableId(tableId);
        ((SysDpColumnRepository)this.baseRepository).saveAndFlush(entity);
    }

    @Override
    public void del(String id) {
        SysDpColumn entity = this.findByIdOrThrow(id);
        ((SysDpColumnRepository)this.baseRepository).delete(entity);
        this.sysDpOptionRepository.deleteByColumnId(id);
        this.sysDpConfigRepository.deleteByColumnId(id);
        this.sysDpResourceRepository.deleteByColumnId(id);
    }

    @Override
    public void update(SysDpColumnUpdateDto dto) {
        SysDpColumn entity = this.findByIdOrThrow(dto.getId());
        this.verifyName(entity.getTableId(), dto.getColumnName(), dto.getId());
        BeanUtil.copyProperties((Object)dto, (Object)entity, (String[])new String[0]);
        ((SysDpColumnRepository)this.baseRepository).saveAndFlush(entity);
    }

    @Override
    public JsonPageResult<List<SysDpColumnVo>> pageByQuery2Vo(SysDpColumnQo qo) {
        int limit = qo.limit();
        JPAQuery query = DslUtil.build((DslQuery)qo, SysDpColumnVo.class);
        QSysDpTable qSysDpTable = QSysDpTable.sysDpTable;
        QSysDpColumn qSysDpColumn = QSysDpColumn.sysDpColumn;
        ((JPAQuery)query.join((EntityPath)qSysDpTable)).on((Predicate)qSysDpColumn.tableId.eq((Expression)qSysDpTable.id));
        ((JPAQuery)query.offset((long)qo.offset())).limit((long)limit);
        query.orderBy(qo.sort());
        long count = query.fetchCount();
        if (count == 0L) {
            return JsonPageResult.success(null, (long)0L, (long)limit);
        }
        return JsonPageResult.success((List)query.fetch(), (long)count, (long)limit);
    }

    private void verifyName(String tableId, String name, String id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDpColumn.class).eq(SysDpColumn::getTableId, (Object)tableId)).eq(SysDpColumn::getColumnName, (Object)name)).ne(StrUtil.isNotBlank((CharSequence)id), SysDpBaseEntity::getId, (Object)id);
        long count = this.countWrapper(wrapper);
        if (count > 0L) {
            throw SysDpException.build("\u6570\u636e\u5217\u3010{}\u3011\u5df2\u7ecf\u914d\u7f6e, \u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", name);
        }
    }
}

