/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import io.gitee.lshaci.scmsaext.common.model.JsonPageResult;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpConfig;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpConfig;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpResource;
import io.gitee.lshaci.scmsaext.datapermission.enums.OwnerType;
import io.gitee.lshaci.scmsaext.datapermission.exception.SysDpException;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpConfigDto;
import io.gitee.lshaci.scmsaext.datapermission.model.qo.SysDpConfigQo;
import io.gitee.lshaci.scmsaext.datapermission.model.vo.SysDpConfigVo;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpConfigRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpResourceRepository;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpConfigService;
import io.gitee.lshaci.scmsaext.datapermission.service.impl.SysDpBaseServiceImpl;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslQuery;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslUtil;
import io.gitee.lshaci.scmsaext.jpa.lambda.LambdaQueryWrapper;
import io.gitee.lshaci.scmsaext.jpa.lambda.Wrappers;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDpConfigServiceImpl
extends SysDpBaseServiceImpl<SysDpConfig, SysDpConfigRepository>
implements SysDpConfigService {
    @Autowired
    private SysDpResourceRepository sysDpResourceRepository;

    @Override
    public SysDpConfig findByIdOrThrow(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setup(SysDpConfigDto dto) {
        this.delAll(dto.getOwnerType(), dto.getOwner());
        this.saveConfig(dto);
    }

    @Override
    public void authorize(SysDpConfigDto dto) {
        LambdaQueryWrapper<SysDpConfig> queryWrapper = this.parseQueryWrapper(dto);
        long count = this.countWrapper(queryWrapper);
        if (count > 0L) {
            throw SysDpException.build("\u91cd\u590d\u6388\u6743", new Object[0]);
        }
        this.saveConfig(dto);
    }

    private void saveConfig(SysDpConfigDto dto) {
        List<String> resourceId = dto.getResourceId();
        if (CollUtil.isEmpty(resourceId)) {
            return;
        }
        List resources = this.sysDpResourceRepository.findAllById(resourceId);
        if (resources.size() < resourceId.size()) {
            throw SysDpException.build("\u9009\u62e9\u8d44\u6e90\u4e2d\u5b58\u5728\u65e0\u6548\u9879", new Object[0]);
        }
        String owner = dto.getOwner();
        String ownerSetter = StrUtil.genSetter((CharSequence)dto.getOwnerType().name());
        List entities = resources.stream().map(r -> this.getSysDpConfig(owner, ownerSetter, (SysDpResource)r)).collect(Collectors.toList());
        ((SysDpConfigRepository)this.baseRepository).saveAll(entities);
    }

    private LambdaQueryWrapper<SysDpConfig> parseQueryWrapper(SysDpConfigDto dto) {
        String owner = dto.getOwner();
        OwnerType ownerType = dto.getOwnerType();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(SysDpConfig.class).in(SysDpConfig::getResourceId, dto.getResourceId());
        switch (ownerType) {
            case user: {
                queryWrapper.eq(SysDpConfig::getUser, (Object)owner);
                break;
            }
            case role: {
                queryWrapper.eq(SysDpConfig::getRole, (Object)owner);
                break;
            }
            case org: {
                queryWrapper.eq(SysDpConfig::getOrg, (Object)owner);
                break;
            }
            default: {
                throw SysDpException.build("\u6743\u9650\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef", new Object[0]);
            }
        }
        return queryWrapper;
    }

    private SysDpConfig getSysDpConfig(String owner, String ownerSetter, SysDpResource resource) {
        SysDpConfig config = new SysDpConfig();
        config.setTableId(resource.getTableId());
        config.setColumnId(resource.getColumnId());
        config.setResourceId(resource.getId());
        ReflectUtil.invoke((Object)config, (String)ownerSetter, (Object[])new Object[]{owner});
        return config;
    }

    @Override
    public void delAll(OwnerType ownerType, String owner) {
        String deleteMethod = "deleteBy" + StrUtil.upperFirst((CharSequence)ownerType.name());
        ReflectUtil.invoke((Object)this.baseRepository, (String)deleteMethod, (Object[])new Object[]{owner});
    }

    @Override
    public void cancel(SysDpConfigDto dto) {
        String deleteMethod = StrUtil.format((CharSequence)"deleteBy{}AndResourceIdIn", (Object[])new Object[]{StrUtil.upperFirst((CharSequence)dto.getOwnerType().name())});
        ReflectUtil.invoke((Object)this.baseRepository, (String)deleteMethod, (Object[])new Object[]{dto.getOwner(), dto.getResourceId()});
    }

    @Override
    public JsonPageResult<List<SysDpConfigVo>> pageByQuery2Vo(SysDpConfigQo qo) {
        int limit = qo.limit();
        JPAQuery query = DslUtil.build((DslQuery)qo, SysDpConfigVo.class);
        QSysDpConfig qSysDpConfig = QSysDpConfig.sysDpConfig;
        QSysDpTable qSysDpTable = QSysDpTable.sysDpTable;
        QSysDpColumn qSysDpColumn = QSysDpColumn.sysDpColumn;
        ((JPAQuery)query.join((EntityPath)qSysDpTable)).on((Predicate)qSysDpConfig.tableId.eq((Expression)qSysDpTable.id));
        ((JPAQuery)query.join((EntityPath)qSysDpColumn)).on((Predicate)qSysDpConfig.columnId.eq((Expression)qSysDpColumn.id));
        String owner = qo.getOwner();
        OwnerType ownerType = qo.getOwnerType();
        if (ownerType == OwnerType.user) {
            query.where((Predicate)qSysDpConfig.user.eq((Object)owner));
        }
        if (ownerType == OwnerType.role) {
            query.where((Predicate)qSysDpConfig.role.eq((Object)owner));
        }
        if (ownerType == OwnerType.org) {
            query.where((Predicate)qSysDpConfig.org.eq((Object)owner));
        }
        ((JPAQuery)query.offset((long)qo.offset())).limit((long)limit);
        query.orderBy(qo.sort());
        long count = query.fetchCount();
        if (count == 0L) {
            return JsonPageResult.success(null, (long)0L, (long)limit);
        }
        return JsonPageResult.success((List)query.fetch(), (long)count, (long)limit);
    }
}

