/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import io.gitee.lshaci.scmsaext.common.model.JsonPageResult;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpBaseEntity;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpOption;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpOption;
import io.gitee.lshaci.scmsaext.datapermission.exception.SysDpException;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpOptionAddDto;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpOptionUpdateDto;
import io.gitee.lshaci.scmsaext.datapermission.model.qo.SysDpOptionQo;
import io.gitee.lshaci.scmsaext.datapermission.model.vo.SysDpOptionVo;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpOptionRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpResourceRepository;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpColumnService;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpOptionService;
import io.gitee.lshaci.scmsaext.datapermission.service.impl.SysDpBaseServiceImpl;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslQuery;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslUtil;
import io.gitee.lshaci.scmsaext.jpa.lambda.LambdaQueryWrapper;
import io.gitee.lshaci.scmsaext.jpa.lambda.Wrappers;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDpOptionServiceImpl
extends SysDpBaseServiceImpl<SysDpOption, SysDpOptionRepository>
implements SysDpOptionService {
    @Autowired
    private SysDpColumnService sysDpColumnService;
    @Autowired
    private SysDpResourceRepository sysDpResourceRepository;

    @Override
    public SysDpOption findByIdOrThrow(String id) {
        return (SysDpOption)((SysDpOptionRepository)this.baseRepository).findById(id).orElseThrow(() -> SysDpException.build("\u53ef\u9009\u6570\u636e\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]));
    }

    @Override
    public void add(SysDpOptionAddDto dto) {
        SysDpColumn sysDpColumn = (SysDpColumn)this.sysDpColumnService.findByIdOrThrow(dto.getColumnId());
        this.verifyLabel(sysDpColumn.getId(), dto.getOptionLabel(), null);
        SysDpOption entity = (SysDpOption)BeanUtil.copyProperties((Object)dto, SysDpOption.class, (String[])new String[0]);
        entity.setTableId(sysDpColumn.getTableId());
        ((SysDpOptionRepository)this.baseRepository).saveAndFlush(entity);
    }

    @Override
    public void del(String id) {
        SysDpOption entity = this.findByIdOrThrow(id);
        long count = this.sysDpResourceRepository.countByOption(entity);
        if (count > 0L) {
            throw SysDpException.build("\u6570\u636e\u3010{}\u3011\u5df2\u914d\u7f6e\u5230\u8d44\u6e90, \u4e0d\u80fd\u5220\u9664", entity.getOptionLabel());
        }
        ((SysDpOptionRepository)this.baseRepository).delete(entity);
    }

    @Override
    public void update(SysDpOptionUpdateDto dto) {
        SysDpOption entity = this.findByIdOrThrow(dto.getId());
        this.verifyLabel(entity.getColumnId(), dto.getOptionLabel(), dto.getId());
        BeanUtil.copyProperties((Object)dto, (Object)entity, (String[])new String[0]);
        ((SysDpOptionRepository)this.baseRepository).saveAndFlush(entity);
    }

    @Override
    public JsonPageResult<List<SysDpOptionVo>> pageByQuery2Vo(SysDpOptionQo qo) {
        int limit = qo.limit();
        JPAQuery query = DslUtil.build((DslQuery)qo, SysDpOptionVo.class);
        QSysDpOption qSysDpOption = QSysDpOption.sysDpOption;
        QSysDpTable qSysDpTable = QSysDpTable.sysDpTable;
        QSysDpColumn qSysDpColumn = QSysDpColumn.sysDpColumn;
        ((JPAQuery)query.join((EntityPath)qSysDpTable)).on((Predicate)qSysDpOption.tableId.eq((Expression)qSysDpTable.id));
        ((JPAQuery)query.join((EntityPath)qSysDpColumn)).on((Predicate)qSysDpOption.columnId.eq((Expression)qSysDpColumn.id));
        ((JPAQuery)query.offset((long)qo.offset())).limit((long)limit);
        query.orderBy(qo.sort());
        long count = query.fetchCount();
        if (count == 0L) {
            return JsonPageResult.success(null, (long)0L, (long)limit);
        }
        return JsonPageResult.success((List)query.fetch(), (long)count, (long)limit);
    }

    private void verifyLabel(String columnId, String label, String id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDpOption.class).eq(SysDpOption::getColumnId, (Object)columnId)).eq(SysDpOption::getOptionLabel, (Object)label)).ne(StrUtil.isNotBlank((CharSequence)id), SysDpBaseEntity::getId, (Object)id);
        long count = this.countWrapper(wrapper);
        if (count > 0L) {
            throw SysDpException.build("\u53ef\u9009\u6570\u636e\u3010{}\u3011\u5df2\u7ecf\u914d\u7f6e, \u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", label);
        }
    }
}

