/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import io.gitee.lshaci.scmsaext.common.model.JsonPageResult;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpBaseEntity;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpResource;
import io.gitee.lshaci.scmsaext.datapermission.entity.QSysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpOption;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpResource;
import io.gitee.lshaci.scmsaext.datapermission.exception.SysDpException;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpResourceAddDto;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpResourceDto;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpResourceUpdateDto;
import io.gitee.lshaci.scmsaext.datapermission.model.qo.SysDpResourceQo;
import io.gitee.lshaci.scmsaext.datapermission.model.vo.SysDpResourceVo;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpConfigRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpOptionRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpResourceRepository;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpColumnService;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpResourceService;
import io.gitee.lshaci.scmsaext.datapermission.service.impl.SysDpBaseServiceImpl;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslQuery;
import io.gitee.lshaci.scmsaext.jpa.dsl.DslUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDpResourceServiceImpl
extends SysDpBaseServiceImpl<SysDpResource, SysDpResourceRepository>
implements SysDpResourceService {
    @Autowired
    private SysDpColumnService sysDpColumnService;
    @Autowired
    private SysDpOptionRepository sysDpOptionRepository;
    @Autowired
    private SysDpConfigRepository sysDpConfigRepository;

    @Override
    public SysDpResource findByIdOrThrow(String id) {
        return (SysDpResource)((SysDpResourceRepository)this.baseRepository).findById(id).orElseThrow(() -> SysDpException.build("\u8d44\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]));
    }

    @Override
    public void add(SysDpResourceAddDto dto) {
        this.verifyOption(dto);
        SysDpColumn sysDpColumn = (SysDpColumn)this.sysDpColumnService.findByIdOrThrow(dto.getColumnId());
        SysDpResource entity = new SysDpResource();
        entity.setTableId(sysDpColumn.getTableId());
        entity.setColumnId(sysDpColumn.getId());
        entity.setMatchType(dto.getMatchType());
        entity.setMatchValue(dto.parseMatchValue());
        ((SysDpResourceRepository)this.baseRepository).saveAndFlush(entity);
    }

    @Override
    public void del(String id) {
        SysDpResource entity = this.findByIdOrThrow(id);
        long count = this.sysDpConfigRepository.countByResource(entity);
        if (count > 0L) {
            throw SysDpException.build("\u8d44\u6e90\u3010{}\u3011\u5df2\u914d\u7f6e, \u4e0d\u80fd\u5220\u9664", new Object[0]);
        }
        ((SysDpResourceRepository)this.baseRepository).delete(entity);
    }

    @Override
    public void update(SysDpResourceUpdateDto dto) {
        this.verifyOption(dto);
        SysDpResource entity = this.findByIdOrThrow(dto.getId());
        entity.setMatchType(dto.getMatchType());
        entity.setMatchValue(dto.parseMatchValue());
        ((SysDpResourceRepository)this.baseRepository).saveAndFlush(entity);
    }

    private void verifyOption(SysDpResourceDto dto) {
        List<String> matchValue = dto.getMatchValue();
        long count = this.sysDpOptionRepository.countByIdIn(matchValue);
        if (count < (long)matchValue.size()) {
            throw SysDpException.build("\u53ef\u9009\u6570\u636e\u4e2d\u5b58\u5728\u65e0\u6548\u9879", new Object[0]);
        }
    }

    @Override
    public JsonPageResult<List<SysDpResourceVo>> pageByQuery2Vo(SysDpResourceQo qo) {
        int limit = qo.limit();
        JPAQuery query = DslUtil.build((DslQuery)qo, SysDpResourceVo.class);
        QSysDpResource qSysDpResource = QSysDpResource.sysDpResource;
        QSysDpTable qSysDpTable = QSysDpTable.sysDpTable;
        QSysDpColumn qSysDpColumn = QSysDpColumn.sysDpColumn;
        ((JPAQuery)query.join((EntityPath)qSysDpTable)).on((Predicate)qSysDpResource.tableId.eq((Expression)qSysDpTable.id));
        ((JPAQuery)query.join((EntityPath)qSysDpColumn)).on((Predicate)qSysDpResource.columnId.eq((Expression)qSysDpColumn.id));
        ((JPAQuery)query.offset((long)qo.offset())).limit((long)limit);
        query.orderBy(qo.sort());
        long count = query.fetchCount();
        if (count == 0L) {
            return JsonPageResult.success(null, (long)0L, (long)limit);
        }
        List data = query.fetch();
        List optionIdList = data.stream().flatMap(SysDpResourceVo::optionId).collect(Collectors.toList());
        Map<String, String> optionId2LabelMap = this.sysDpOptionRepository.findAllById(optionIdList).stream().collect(Collectors.toMap(SysDpBaseEntity::getId, SysDpOption::getOptionLabel));
        for (SysDpResourceVo vo : data) {
            String optionLabel = vo.optionId().map(optionId2LabelMap::get).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(","));
            vo.setOptionLabel(optionLabel);
        }
        return JsonPageResult.success((List)data, (long)count, (long)limit);
    }
}

