/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import io.gitee.lshaci.scmsaext.datapermission.core.SysDpBaseEntity;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpColumn;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpOption;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpResource;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.enums.ColumnType;
import io.gitee.lshaci.scmsaext.datapermission.enums.MatchType;
import io.gitee.lshaci.scmsaext.datapermission.enums.OptionValueSource;
import io.gitee.lshaci.scmsaext.datapermission.exception.SysDpException;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpTableDto;
import io.gitee.lshaci.scmsaext.datapermission.model.dto.SysDpTableUpdateDto;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpColumnRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpConfigRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpOptionRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpResourceRepository;
import io.gitee.lshaci.scmsaext.datapermission.repository.SysDpTableRepository;
import io.gitee.lshaci.scmsaext.datapermission.service.SysDpTableService;
import io.gitee.lshaci.scmsaext.datapermission.service.impl.SysDpBaseServiceImpl;
import io.gitee.lshaci.scmsaext.jpa.lambda.LambdaQueryWrapper;
import io.gitee.lshaci.scmsaext.jpa.lambda.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDpTableServiceImpl
extends SysDpBaseServiceImpl<SysDpTable, SysDpTableRepository>
implements SysDpTableService {
    @Autowired
    private SysDpColumnRepository sysDpColumnRepository;
    @Autowired
    private SysDpOptionRepository sysDpOptionRepository;
    @Autowired
    private SysDpConfigRepository sysDpConfigRepository;
    @Autowired
    private SysDpResourceRepository sysDpResourceRepository;

    @Override
    public SysDpTable findByIdOrThrow(String id) {
        return (SysDpTable)((SysDpTableRepository)this.baseRepository).findById(id).orElseThrow(() -> SysDpException.build("\u8868\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]));
    }

    @Override
    public void add(SysDpTableDto dto) {
        this.verifyName(dto.getTableName(), null);
        SysDpTable entity = (SysDpTable)BeanUtil.copyProperties((Object)dto, SysDpTable.class, (String[])new String[0]);
        SysDpTable dbEntity = (SysDpTable)((SysDpTableRepository)this.baseRepository).saveAndFlush(entity);
        SysDpColumn column = this.initAllColumn(dbEntity);
        SysDpOption option = this.initAllOption(column);
        this.initAllResource(option);
    }

    private void initAllResource(SysDpOption option) {
        SysDpResource resource = new SysDpResource();
        resource.setTableId(option.getTableId());
        resource.setColumnId(option.getColumnId());
        resource.setMatchType(MatchType.EQ);
        resource.setMatchValue(option.getId());
        this.sysDpResourceRepository.saveAndFlush(resource);
    }

    private SysDpOption initAllOption(SysDpColumn column) {
        SysDpOption option = new SysDpOption();
        option.setTableId(column.getTableId());
        option.setColumnId(column.getId());
        option.setOptionLabel("\u5168\u90e8");
        option.setOptionValue("1");
        option.setOptionValueSource(OptionValueSource.database);
        return (SysDpOption)this.sysDpOptionRepository.saveAndFlush(option);
    }

    private SysDpColumn initAllColumn(SysDpTable table) {
        SysDpColumn column = new SysDpColumn();
        column.setTableId(table.getId());
        column.setColumnLabel("\u5168\u90e8");
        column.setColumnName("1");
        column.setColumnType(ColumnType.LongVal);
        column.setColumnRemark("\u8bf7\u52ff\u64cd\u4f5c");
        return (SysDpColumn)this.sysDpColumnRepository.saveAndFlush(column);
    }

    @Override
    public void del(String id) {
        SysDpTable entity = this.findByIdOrThrow(id);
        ((SysDpTableRepository)this.baseRepository).delete(entity);
        this.sysDpColumnRepository.deleteByTableId(id);
        this.sysDpOptionRepository.deleteByTableId(id);
        this.sysDpConfigRepository.deleteByTableId(id);
        this.sysDpResourceRepository.deleteByTableId(id);
    }

    @Override
    public void update(SysDpTableUpdateDto dto) {
        SysDpTable entity = this.findByIdOrThrow(dto.getId());
        this.verifyName(dto.getTableName(), dto.getId());
        BeanUtil.copyProperties((Object)dto, (Object)entity, (String[])new String[0]);
        ((SysDpTableRepository)this.baseRepository).saveAndFlush(entity);
    }

    private void verifyName(String name, String id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDpTable.class).eq(SysDpTable::getTableName, (Object)name)).ne(StrUtil.isNotBlank((CharSequence)id), SysDpBaseEntity::getId, (Object)id);
        long count = this.countWrapper(wrapper);
        if (count > 0L) {
            throw SysDpException.build("\u6570\u636e\u8868\u3010{}\u3011\u5df2\u7ecf\u914d\u7f6e, \u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", name);
        }
    }
}

