/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lshaci.scmsaext.datapermission.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.threadlocal.NamedThreadLocal;
import io.gitee.lshaci.scmsaext.datapermission.entity.SysDpTable;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpTableHelper;
import io.gitee.lshaci.scmsaext.datapermission.helper.SysDpUserResourceHelper;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysDpUtil {
    private static final NamedThreadLocal<Boolean> ENABLE = new NamedThreadLocal("sys_dp_enable");
    private static SysDpTableHelper sysDpTableHelper;
    private static SysDpUserResourceHelper sysDpUserResourceHelper;

    public static void enable() {
        ENABLE.set((Object)true);
    }

    public static void disable() {
        ENABLE.set((Object)false);
    }

    public static void remove() {
        ENABLE.remove();
    }

    public static boolean isEnable() {
        return (Boolean)Optional.ofNullable(ENABLE.get()).orElse(sysDpTableHelper.isEnable());
    }

    public static void clearCache() {
        sysDpTableHelper.clearCache();
        sysDpUserResourceHelper.clearCache();
    }

    public static Expression injectExpression(Table table) {
        String tableName = table.getName().toLowerCase();
        if (sysDpTableHelper.isSysDpTable(tableName)) {
            return null;
        }
        if (sysDpTableHelper.isExcludeTable(tableName)) {
            return null;
        }
        SysDpTable sysDpTable = sysDpTableHelper.isResourceTable(tableName);
        if (sysDpTable == null) {
            return null;
        }
        List<Expression> userResource = sysDpUserResourceHelper.userResource(sysDpTable.getId(), table);
        if (CollUtil.isEmpty(userResource)) {
            if (sysDpTableHelper.noResourcePermitAll()) {
                return null;
            }
            return new Parenthesis((Expression)new EqualsTo((Expression)new Column("1"), (Expression)new LongValue(0L)));
        }
        Expression injectExpression = userResource.get(0);
        if (userResource.size() == 1) {
            return new Parenthesis(injectExpression);
        }
        for (int i = 1; i < userResource.size(); ++i) {
            injectExpression = new OrExpression(injectExpression, userResource.get(i));
        }
        return new Parenthesis(injectExpression);
    }

    @Autowired
    public void setSysDpTableHelper(SysDpTableHelper sysDpTableHelper) {
        SysDpUtil.sysDpTableHelper = sysDpTableHelper;
    }

    @Autowired
    public void setSysDpUserResourceHelper(SysDpUserResourceHelper sysDpUserResourceHelper) {
        SysDpUtil.sysDpUserResourceHelper = sysDpUserResourceHelper;
    }
}

