/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.common;

import com.swak.archiver.common.SwakTemplateExecutor;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SwakTemplateExecutorImpl
implements SwakTemplateExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwakTemplateExecutorImpl.class);
    private TransactionTemplate transactionTemplate;
    private JdbcTemplate jdbcTemplate;

    public SwakTemplateExecutorImpl(DataSource dataSource, boolean isMysql) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        if (isMysql) {
            DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(dataSource);
            this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)platformTransactionManager);
        }
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public void execute(String sql) throws DataAccessException {
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public Integer findTotalCount(String sql) throws DataAccessException {
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
    }

    @Override
    public Long findMaxId(String sql) throws DataAccessException {
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
    }

    @Override
    public SqlRowSet queryForRowSet(String sql) throws DataAccessException {
        return this.jdbcTemplate.queryForRowSet(sql);
    }

    @Override
    public int batchUpdate(String sql) throws DataAccessException {
        return this.jdbcTemplate.update(sql);
    }
}

