/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.executor;

import com.google.common.collect.Sets;
import com.swak.archiver.ArchiveHandler;
import com.swak.archiver.common.IbsStringHelper;
import com.swak.archiver.common.SwakTemplateExecutor;
import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.archiver.conf.ArchiveLog;
import com.swak.archiver.executor.ArchiverDataEngine;
import com.swak.archiver.notify.ArchiveLogMonitor;
import com.swak.archiver.notify.ArchiveMonitor;
import com.swak.common.chain.FilterChain;
import com.swak.common.chain.FilterChainFactory;
import com.swak.common.exception.ArchiveException;
import com.swak.common.util.GetterUtil;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchiverEngineExecutor
implements ArchiverDataEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiverEngineExecutor.class);
    private SwakTemplateExecutor executor;
    private ArchiveMonitor monitor;

    protected abstract List<ArchiveHandler> getArchiveHandler();

    public ArchiverEngineExecutor(SwakTemplateExecutor executor, ArchiveMonitor monitor) {
        this.executor = executor;
        this.monitor = monitor;
    }

    @Override
    public void engine(ArchiveConfig config) {
        ArchiveItem context = new ArchiveItem(config);
        context.setExecutor(this.executor);
        try {
            this.init();
            FilterChain filterChain = FilterChainFactory.buildFilterChain(this.getArchiveHandler());
            filterChain.doFilter((Object)context);
            this.done(context, null);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5f52\u6863\u5931\u8d25\uff01", (Throwable)e);
            this.done(context, e);
        }
    }

    public void init() throws ArchiveException {
        if (this.executor == null) {
            throw new ArchiveException("Property 'SwakTemplateExecutor' is required");
        }
    }

    public void done(ArchiveItem item, Exception ex) {
        if (this.monitor == null) {
            this.monitor = new ArchiveLogMonitor();
        }
        ArchiveLog.ArchiveLogBuilder builder = ArchiveLog.builder();
        if (ex == null) {
            builder.succ(true);
        } else {
            builder.succ(false);
        }
        builder.config(item.getConfig());
        Integer remainCount = 0;
        remainCount = item.getConfig().isArchive() ? Integer.valueOf(GetterUtil.getInteger((Integer)item.getDataCount()) - item.getProgress().get()) : Integer.valueOf(GetterUtil.getInteger((Integer)item.getDataCount()) - item.getDelNum().get());
        builder.maxId(item.getMaxId()).limit(item.getConfig().getLimit()).progressSize(item.getProgress().get()).delTotalNum(item.getDelNum().get()).repeatNum(item.getRepeatNum().get()).retries(item.getRetries().get()).dataCount(item.getDataCount()).startTime(new Date(item.getStartTime())).endTime(new Date()).remainCount(remainCount > 0 ? remainCount : 0).costTime(IbsStringHelper.msTimeformat2String(System.currentTimeMillis() - item.getStartTime()));
        if (ex != null) {
            builder.traceInfo(ex.getMessage());
        }
        builder.sendEmail(item.getConfig().isSendEmail());
        builder.recipients(Sets.newHashSet((Iterable)GetterUtil.getSplit2List((String)item.getConfig().getRecipients())));
        this.monitor.monitor(builder.build());
    }

    @Override
    public void cancel() {
    }
}

