/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.executor.impl;

import com.swak.archiver.common.IbsStringHelper;
import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.archiver.executor.ArchiveExecutor;
import com.swak.common.exception.ArchiveException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public abstract class AbsArchiveExecutor
implements ArchiveExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbsArchiveExecutor.class);

    protected void handlerNextMaxId(ArchiveItem item) {
        ArchiveConfig config = item.getConfig();
        try {
            StringBuilder builderSql = new StringBuilder();
            builderSql.append("SELECT MAX(id) FROM ").append(config.getDesTblName());
            Long maxId = item.getExecutor().findMaxId(builderSql.toString());
            log.warn("\u76ee\u6807\u8868nextMaxId\u83b7\u53d6 - \u76ee\u6807\u8868: {} - nextMaxId(id) :{}", new Object[]{config.getDesTblName(), maxId});
            item.setNextMaxId(maxId);
        }
        catch (Exception e) {
            log.error("\u76ee\u6807\u8868nextMaxId\u83b7\u53d6 - \u76ee\u6807\u8868: {}  - \u5f02\u5e38\u4fe1\u606f\uff1a {}", (Object)config.getDesTblName(), (Object)e.getMessage());
            ArchiveException.throwException((Throwable)e);
        }
    }

    public void commitArchiveLog(ArchiveItem item, int insertNum, int deleteNum, boolean isSucc) {
        StringBuffer strBuff = new StringBuffer();
        if (isSucc) {
            strBuff.append("commit\u6210\u529f  ");
        } else {
            strBuff.append("\u6267\u884c\u5931\u8d25\u56de\u6eda   ");
        }
        strBuff.append(" - \u5f53\u524d\u5f52\u6863\u8868 : ").append(item.getConfig().getSrcTblName());
        strBuff.append(" - \u76ee\u6807\u8868 : ").append(item.getConfig().getDesTblName());
        strBuff.append(" - \u6700\u5927max(id) : ").append(item.getMaxId());
        strBuff.append(" - Limit\u6570 : ").append(item.getConfig().getLimit());
        strBuff.append(" - txn-size : ").append(item.getConfig().getTxnSize());
        strBuff.append(" - \u5f52\u6863\u884c\u6570 : ").append(insertNum);
        strBuff.append(" - \u5f52\u6863\u91cd\u590d\u884c\u6570 : ").append(item.getRepeatNum().get());
        strBuff.append(" - \u5220\u9664\u884c\u6570: ").append(deleteNum);
        strBuff.append(" - \u91cd\u8bd5\u603b\u6b21\u6570 : ").append(item.getRetries().get());
        strBuff.append(" - \u82b1\u8d39\u65f6\u95f4: ").append(IbsStringHelper.msTimeformat2String(System.currentTimeMillis() - item.getStartTime()));
        log.warn(strBuff.toString());
    }

    public void commitDelLog(ArchiveItem item, int deleteNum, boolean isSucc) {
        StringBuffer strBuff = new StringBuffer();
        if (isSucc) {
            strBuff.append("commit\u6210\u529f  ");
        } else {
            strBuff.append("\u6267\u884c\u5931\u8d25\u56de\u6eda   ");
        }
        strBuff.append(" - \u5f53\u524d\u8868 : ").append(item.getConfig().getSrcTblName());
        strBuff.append(" - \u6700\u5927max(id) : ").append(item.getMaxId());
        strBuff.append(" - Limit\u6570 : ").append(item.getConfig().getLimit());
        strBuff.append(" - txn-size : ").append(item.getConfig().getTxnSize());
        strBuff.append(" - \u5220\u9664\u884c\u6570: ").append(deleteNum);
        strBuff.append(" - \u5220\u9664\u603b\u884c\u6570: ").append(item.getDelNum().get());
        strBuff.append(" - \u5269\u4f59\u603b\u884c\u6570: ").append(item.getConfig().getProgressSize() - item.getDelNum().get());
        strBuff.append(" - \u91cd\u8bd5\u603b\u6b21\u6570 : ").append(item.getRetries().get());
        strBuff.append(" - \u82b1\u8d39\u65f6\u95f4: ").append(IbsStringHelper.msTimeformat2String(System.currentTimeMillis() - item.getStartTime()));
        log.warn(strBuff.toString());
    }

    public class SwakTransactionCallback
    implements TransactionCallback<Integer> {
        private ArchiveItem item;
        private List<Map<String, Object>> archiveData;

        public SwakTransactionCallback(ArchiveItem item, List<Map<String, Object>> archiveData) {
            this.item = item;
            this.archiveData = archiveData;
        }

        public Integer doInTransaction(TransactionStatus status) {
            ArchiveConfig config = this.item.getConfig();
            if (!config.isArchive()) {
                return this.doDelTransaction(status);
            }
            return this.doArchiveTransaction(status);
        }

        private Integer doArchiveTransaction(TransactionStatus status) {
            int insertNum = 0;
            int deleteNum = 0;
            ArchiveConfig config = this.item.getConfig();
            try {
                insertNum = AbsArchiveExecutor.this.archiveItem(this.item, this.archiveData);
                if (insertNum > 0) {
                    if (config.isPurge()) {
                        deleteNum = AbsArchiveExecutor.this.deleteItem(this.item, this.archiveData);
                        this.item.getDelNum().addAndGet(deleteNum);
                    }
                    if (insertNum > this.item.getConfig().getLimit()) {
                        this.item.getProgress().addAndGet(this.item.getConfig().getLimit());
                    } else {
                        this.item.getProgress().addAndGet(insertNum);
                    }
                    this.item.getRepeatNum().addAndGet(insertNum - deleteNum);
                }
            }
            catch (Exception e) {
                log.error("===> \u6279\u6b21\u5f52\u6863\u5931\u8d25\uff0c\u6267\u884c\u56de\u6eda\u64cd\u4f5c", (Throwable)e);
                AbsArchiveExecutor.this.commitArchiveLog(this.item, insertNum, deleteNum, false);
                status.setRollbackOnly();
                throw new RuntimeException("\u6279\u6b21\u5f52\u6863\u5931\u8d25\uff0c\u6267\u884c\u56de\u6eda\u64cd\u4f5c", e);
            }
            AbsArchiveExecutor.this.commitArchiveLog(this.item, insertNum, deleteNum, true);
            return insertNum;
        }

        private Integer doDelTransaction(TransactionStatus status) {
            int deleteNum = 0;
            try {
                deleteNum = AbsArchiveExecutor.this.deleteItem(this.item, this.archiveData);
                this.item.getDelNum().addAndGet(deleteNum);
                this.item.getProgress().addAndGet(deleteNum);
            }
            catch (Exception e) {
                log.error("===> \u6279\u6b21\u5f52\u6863\u5931\u8d25\uff0c\u6267\u884c\u56de\u6eda\u64cd\u4f5c", (Throwable)e);
                AbsArchiveExecutor.this.commitDelLog(this.item, deleteNum, false);
                status.setRollbackOnly();
                throw new RuntimeException("\u6279\u6b21\u5f52\u6863\u5931\u8d25\uff0c\u6267\u884c\u56de\u6eda\u64cd\u4f5c", e);
            }
            AbsArchiveExecutor.this.commitDelLog(this.item, deleteNum, true);
            return deleteNum;
        }
    }
}

