/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.executor.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.archiver.executor.impl.AbsArchiveExecutor;
import com.swak.common.dto.ListPager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class AloneArchiveExecutor
extends AbsArchiveExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AloneArchiveExecutor.class);

    @Override
    public void execute(ArchiveItem item) {
        while (item.getProgress().get() < item.getConfig().getProgressSize()) {
            try {
                List<Map<String, Object>> archiveData = this.queryItems(item);
                if (CollectionUtils.isEmpty(archiveData)) {
                    return;
                }
                int insertRows = this.doTransaction(item, archiveData);
                if (insertRows <= 0) {
                    return;
                }
                if (!item.getConfig().isPurge()) {
                    super.handlerNextMaxId(item);
                }
            }
            catch (Exception e) {
                int retries = item.getRetries().incrementAndGet();
                log.error("execute  ArchiveItem error,retries:{}", (Object)retries, (Object)e);
                if (item.getRetries().get() >= item.getConfig().getRetries()) {
                    return;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                TimeUnit.MILLISECONDS.sleep(item.getConfig().getSleep());
                log.warn("\u6bcf\u6b21\u5f52\u6863\u4e86limit\u4e2a\u884c\u8bb0\u5f55\u540e\u4f11\u7720{} \u6beb\u79d2", (Object)item.getConfig().getSleep());
            }
            catch (Exception e) {
                log.error("sleep error", (Throwable)e);
            }
        }
    }

    public int doTransaction(ArchiveItem item, List<Map<String, Object>> archivedata) {
        TransactionTemplate transactionTemplate = item.getExecutor().getTransactionTemplate();
        AtomicInteger executeCount = new AtomicInteger(0);
        int txnBacth = 1;
        ListPager listPager = new ListPager(archivedata, item.getConfig().getTxnSize());
        listPager.setPageIndex(txnBacth);
        List txndata = null;
        while (CollectionUtils.isNotEmpty((Collection)(txndata = listPager.getPageList()))) {
            int insertRows = (Integer)transactionTemplate.execute((TransactionCallback)new AbsArchiveExecutor.SwakTransactionCallback(item, txndata));
            if (insertRows <= 0) {
                return executeCount.get();
            }
            if (insertRows > txndata.size()) {
                executeCount.addAndGet(txndata.size());
            } else {
                executeCount.addAndGet(insertRows);
            }
            item.getRepeatNum().addAndGet(insertRows - txndata.size());
            listPager.setPageIndex(++txnBacth);
        }
        return executeCount.get();
    }

    protected List<Map<String, Object>> queryItems(ArchiveItem item) {
        StringBuilder builderSql = new StringBuilder();
        builderSql.append("SELECT ").append(Joiner.on((String)",").join((Object[])item.getCols()).toString()).append(" FROM ").append(item.getConfig().getSrcTblName() + " FORCE INDEX(`PRIMARY`)").append(" WHERE id<=").append(item.getMaxId());
        if (!item.getConfig().isPurge()) {
            builderSql.append(" and id>").append(item.getNextMaxId());
        }
        builderSql.append(" order by id LIMIT ").append(item.getConfig().getLimit());
        return item.getExecutor().getJdbcTemplate().queryForList(builderSql.toString());
    }

    @Override
    public int archiveItem(ArchiveItem item, List<Map<String, Object>> archiveData) {
        ArchiveConfig config = item.getConfig();
        if (CollectionUtils.isEmpty(archiveData)) {
            return 0;
        }
        ArrayList questionMark = Lists.newArrayListWithExpectedSize((int)item.getCols().length);
        Arrays.stream(item.getCols()).forEach(a -> questionMark.add("?"));
        StringBuilder builderSql = new StringBuilder();
        builderSql.append("replace INTO ").append(config.getDesTblName()).append("(").append(Joiner.on((String)",").join((Object[])item.getCols()).toString()).append(")").append(" VALUES(").append(Joiner.on((String)",").join((Iterable)questionMark).toString()).append(")");
        ArrayList batchArgs = Lists.newArrayListWithExpectedSize((int)archiveData.size());
        archiveData.stream().forEach(dataMap -> {
            Object[] parameter = new Object[item.getCols().length];
            for (int i = 0; i < item.getCols().length; ++i) {
                String colName = item.getCols()[i];
                parameter[i] = dataMap.get(colName);
            }
            batchArgs.add(parameter);
        });
        int[] rowArrays = item.getExecutor().getJdbcTemplate().batchUpdate(builderSql.toString(), (List)batchArgs);
        return rowArrays.length;
    }

    @Override
    public int deleteItem(ArchiveItem item, List<Map<String, Object>> archivedata) {
        ArchiveConfig config = item.getConfig();
        String deleteSql = "DELETE FROM " + config.getSrcTblName() + " WHERE id<=? AND id=?";
        int deleteNum = 0;
        if (CollectionUtils.isNotEmpty(archivedata)) {
            ArrayList<Object[]> batchArgs = new ArrayList<Object[]>(archivedata.size());
            for (Map<String, Object> data : archivedata) {
                Long nextId = (Long)data.get("id");
                if (nextId == null) continue;
                Object[] batchParameter = new Object[]{item.getMaxId(), nextId};
                batchArgs.add(batchParameter);
            }
            if (CollectionUtils.isNotEmpty(batchArgs)) {
                int[] rowArrays = item.getExecutor().getJdbcTemplate().batchUpdate(deleteSql, batchArgs);
                return rowArrays.length;
            }
        }
        return deleteNum;
    }
}

