/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.executor.impl;

import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.archiver.executor.impl.AbsArchiveExecutor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveClickhouseExecutor
extends AbsArchiveExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiveClickhouseExecutor.class);

    @Override
    public void execute(ArchiveItem item) {
        for (String partition : item.getPartition()) {
            this.deletePartitionItem(item, partition);
            try {
                TimeUnit.MILLISECONDS.sleep(item.getConfig().getSleep());
                log.warn("\u6bcf\u6b21\u5220\u9664\u4e00\u4e2a\u5206\u533a\u540e\u4f11\u7720{} \u6beb\u79d2", (Object)item.getConfig().getSleep());
            }
            catch (Exception e) {
                log.error("\u6bcf\u6b21\u5220\u9664\u4e00\u4e2a\u5206\u533a\u540e\u4f11\u7720\u62a5\u9519\uff01");
            }
        }
    }

    public void deletePartitionItem(ArchiveItem item, String partition) {
        try {
            if (StringUtils.isEmpty((CharSequence)partition)) {
                return;
            }
            ArchiveConfig config = item.getConfig();
            StringBuilder builderSql = new StringBuilder();
            builderSql.append("alter table ").append(config.getDatabaseName()).append(".").append(config.getSrcTblName()).append(" drop partition '").append(partition).append("'");
            if (StringUtils.isNotEmpty((CharSequence)config.getClusterName())) {
                builderSql.append(" on cluster ").append(config.getClusterName());
            }
            item.getExecutor().getJdbcTemplate().execute(builderSql.toString());
        }
        catch (Exception e) {
            int retries = item.getRetries().incrementAndGet();
            log.error("\u6267\u884c\u5220\u9664\u5206\u533a\u62a5\u9519\uff0c\u91cd\u8bd5\u6b21\u6570\u4e3a  retries:{}", (Object)retries, (Object)e);
            if (item.getRetries().get() >= item.getConfig().getRetries()) {
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e1) {
                log.error("{} ms\u540e\u91cd\u8bd5\uff01", (Object)500);
            }
        }
    }

    @Override
    public int archiveItem(ArchiveItem item, List<Map<String, Object>> archiveData) {
        return 0;
    }

    @Override
    public int deleteItem(ArchiveItem item, List<Map<String, Object>> archiveData) {
        return 0;
    }
}

