/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.executor.impl;

import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.archiver.executor.impl.AbsArchiveExecutor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class BatchDeleteExecutor
extends AbsArchiveExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDeleteExecutor.class);

    @Override
    public void execute(ArchiveItem item) {
        TransactionTemplate transactionTemplate = item.getExecutor().getTransactionTemplate();
        while (item.getProgress().get() < item.getConfig().getProgressSize()) {
            try {
                int delRows = (Integer)transactionTemplate.execute((TransactionCallback)new AbsArchiveExecutor.SwakTransactionCallback(item, null));
                if (delRows <= 0) {
                    break;
                }
            }
            catch (Exception e) {
                int retries = item.getRetries().incrementAndGet();
                log.error("\u6267\u884c\u5220\u9664\u62a5\u9519\uff0c\u91cd\u8bd5\u6b21\u6570\u4e3a  retries:{}", (Object)retries, (Object)e);
                if (item.getRetries().get() >= item.getConfig().getRetries()) break;
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                    continue;
                }
                catch (InterruptedException e1) {
                    log.error("{} ms\u540e\u91cd\u8bd5\uff01", (Object)500);
                }
            }
            try {
                TimeUnit.MILLISECONDS.sleep(item.getConfig().getSleep());
                log.warn("\u6bcf\u6b21\u5220\u9664limit\u4e2a\u884c\u8bb0\u5f55\u540e\u4f11\u7720{} \u6beb\u79d2", (Object)item.getConfig().getSleep());
            }
            catch (Exception e) {
                log.error("\u6bcf\u6b21\u5220\u9664\u4e86limit\u4e2a\u884c\u8bb0\u5f55\u540e\u4f11\u7720\u62a5\u9519\uff01");
            }
        }
    }

    @Override
    public int archiveItem(ArchiveItem item, List<Map<String, Object>> archiveData) {
        return 0;
    }

    @Override
    public int deleteItem(ArchiveItem item, List<Map<String, Object>> archiveData) {
        ArchiveConfig config = item.getConfig();
        StringBuilder builderSql = new StringBuilder();
        builderSql.append("DELETE FROM ").append(config.getSrcTblName()).append(" WHERE id<=").append(item.getMaxId()).append(" order by id LIMIT ").append(config.getLimit());
        int rows = item.getExecutor().batchUpdate(builderSql.toString());
        return rows;
    }
}

