/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.notify;

import com.google.common.base.Joiner;
import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveLog;
import com.swak.archiver.notify.ArchiveMonitor;
import java.util.Collections;
import java.util.Optional;

public abstract class AbstractArchiveMonitor
implements ArchiveMonitor {
    @Override
    public void monitor(ArchiveLog archiveLog) {
        if (archiveLog.getConfig().isClickhouseDb()) {
            this._monitor(this.monitorClickhouseLog(archiveLog));
            return;
        }
        this._monitor(this.monitorLog(archiveLog));
    }

    public abstract void _monitor(String var1);

    protected String monitorLog(ArchiveLog archiveLog) {
        ArchiveConfig config = archiveLog.getConfig();
        StringBuilder stringBuilder = new StringBuilder();
        if (archiveLog.isSucc()) {
            stringBuilder.append(config.isArchive() ? "\u5f52\u6863\u6570\u636e\u6210\u529f\u6c47\u603b  " : "\u6e05\u9664\u5386\u53f2\u6570\u636e\u6210\u529f\u6c47\u603b");
        } else {
            stringBuilder.append(config.isArchive() ? "\u5f52\u6863\u6570\u636e\u5931\u8d25   " : "\u6e05\u9664\u5386\u53f2\u6570\u636e\u5931\u8d25 ");
        }
        stringBuilder.append(" - \u8c03\u5ea6\u7c7b\u578b : ").append(config.isArchive() ? "\u5f52\u6863" : "\u5386\u53f2\u6570\u636e\u6e05\u9664");
        stringBuilder.append(" - \u6570\u636e\u5e93\u7c7b\u578b : mysql");
        stringBuilder.append(" - \u6570\u636e\u5e93 : ").append(config.getDatabaseName());
        stringBuilder.append(" - \u5f53\u524d\u5f52\u6863\u8868 : ").append(config.getSrcTblName());
        if (config.isArchive()) {
            stringBuilder.append(" - \u76ee\u6807\u8868 : ").append(config.getDesTblName());
        }
        stringBuilder.append(" - " + (config.isArchive() ? "\u672a\u5f52\u6863\u6570 : " : "\u672a\u5220\u9664\u6570:")).append(archiveLog.getRemainCount());
        stringBuilder.append(" - \u6700\u5927max(id) : ").append(archiveLog.getMaxId());
        stringBuilder.append(" - Limit\u6570 : ").append(archiveLog.getLimit());
        if (config.isArchive()) {
            stringBuilder.append(" - \u5f52\u6863\u603b\u6570 : ").append(archiveLog.getProgressSize());
            stringBuilder.append(" - \u5f52\u6863\u91cd\u590d\u603b\u6570 : ").append(archiveLog.getRepeatNum());
        }
        stringBuilder.append(" - \u603b\u6570\u636e\u91cf: ").append(archiveLog.getDataCount());
        stringBuilder.append(" - \u5220\u9664\u603b\u6570: ").append(archiveLog.getDelTotalNum());
        stringBuilder.append(" - \u91cd\u8bd5\u603b\u6b21\u6570 : ").append(archiveLog.getRetries());
        if (config.isArchive()) {
            stringBuilder.append(" - \u662f\u5426\u5220\u9664\u5f52\u6863\u8868\u6570\u636e : ").append(config.isPurge());
        }
        stringBuilder.append(" - where\u6761\u4ef6: ").append(config.getWhere());
        stringBuilder.append(" - \u603b\u82b1\u8d39\u65f6\u95f4: ").append(archiveLog.getCostTime());
        if (!archiveLog.isSucc()) {
            stringBuilder.append(" - \u5f02\u5e38\u4fe1\u606f: ").append(archiveLog.getTraceInfo());
        }
        return stringBuilder.toString();
    }

    protected String monitorClickhouseLog(ArchiveLog archiveLog) {
        ArchiveConfig config = archiveLog.getConfig();
        StringBuilder stringBuilder = new StringBuilder();
        if (archiveLog.isSucc()) {
            stringBuilder.append(config.isArchive() ? "\u5f52\u6863\u6570\u636e\u6210\u529f\u6c47\u603b  " : "\u6e05\u9664\u5386\u53f2\u6570\u636e\u6210\u529f\u6c47\u603b");
        } else {
            stringBuilder.append(config.isArchive() ? "\u5f52\u6863\u6570\u636e\u5931\u8d25   " : "\u6e05\u9664\u5386\u53f2\u6570\u636e\u5931\u8d25 ");
        }
        stringBuilder.append(" - \u8c03\u5ea6\u7c7b\u578b : ").append(config.isArchive() ? "\u5f52\u6863" : "\u5386\u53f2\u6570\u636e\u6e05\u9664");
        stringBuilder.append(" - \u6570\u636e\u5e93\u7c7b\u578b : clickhouse");
        stringBuilder.append(" - \u6570\u636e\u5e93 : ").append(config.getDatabaseName());
        stringBuilder.append(" - \u5143\u6570\u636e\u8868 : ").append(config.getSrcTblName());
        if (config.isArchive()) {
            stringBuilder.append(" - \u76ee\u6807\u8868 : ").append(config.getDesTblName());
        }
        stringBuilder.append(" - " + (config.isArchive() ? "\u5f52\u6863\u5206\u533a : " : "\u5220\u9664\u5206\u533a:")).append(Joiner.on((String)",").join((Iterable)Optional.ofNullable(archiveLog.getPartition()).orElse(Collections.emptyList())).toString());
        stringBuilder.append(" - \u91cd\u8bd5\u603b\u6b21\u6570 : ").append(archiveLog.getRetries());
        if (config.isArchive()) {
            stringBuilder.append(" - \u662f\u5426\u5220\u9664\u5f52\u6863\u8868\u6570\u636e : ").append(config.isPurge());
        }
        stringBuilder.append(" - where\u6761\u4ef6: ").append(config.getWhere());
        stringBuilder.append(" - \u603b\u82b1\u8d39\u65f6\u95f4: ").append(archiveLog.getCostTime());
        if (!archiveLog.isSucc()) {
            stringBuilder.append(" - \u5f02\u5e38\u4fe1\u606f: ").append(archiveLog.getTraceInfo());
        }
        return stringBuilder.toString();
    }
}

