/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.spi;

import com.google.common.collect.Lists;
import com.swak.archiver.ArchiveHandler;
import com.swak.archiver.conf.AnalyzeEnum;
import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.common.chain.FilterInvoker;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeTableHandler
implements ArchiveHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyzeTableHandler.class);

    public void doFilter(ArchiveItem context, FilterInvoker<ArchiveItem> nextFilter) {
        boolean isAnalyze;
        boolean retries;
        boolean bl = retries = context.getRetries().get() >= context.getConfig().getRetries();
        if (retries) {
            log.error("\u5f02\u5e38\u8d85\u8fc7\u91cd\u8bd5\u6700\u5927\u6570\uff1a{},\u4e0d\u8fdb\u884c analyze table\u4f18\u5316\uff01", (Object)context.getRetries().get());
            nextFilter.invoke((Object)context);
            return;
        }
        ArchiveConfig config = context.getConfig();
        AnalyzeEnum analyzeEnum = config.getAnalyze();
        boolean bl2 = isAnalyze = config.getAnalyze() != null && !Objects.equals((Object)AnalyzeEnum.NONE, (Object)analyzeEnum);
        if (isAnalyze) {
            StringBuffer maintBuff = new StringBuffer();
            maintBuff.append(analyzeEnum.opt);
            if (config.isLocal()) {
                maintBuff.append("/*!40101 NO_WRITE_TO_BINLOG*/");
            }
            String maint = maintBuff.append(" TABLE ").toString();
            ArrayList analyzeTableNames = Lists.newArrayListWithCapacity((int)2);
            switch (analyzeEnum.target) {
                case ALL: {
                    analyzeTableNames.add(config.getSrcTblName());
                    analyzeTableNames.add(config.getDesTblName());
                    break;
                }
                case SOURCE: {
                    analyzeTableNames.add(config.getSrcTblName());
                    break;
                }
                case DEST: {
                    analyzeTableNames.add(config.getDesTblName());
                    break;
                }
            }
            this.analyzeTable(context, maint, analyzeTableNames);
        }
        nextFilter.invoke((Object)context);
    }

    private void analyzeTable(ArchiveItem context, String maint, List<String> tableNames) {
        if (CollectionUtils.isEmpty(tableNames)) {
            return;
        }
        for (String tableName : tableNames) {
            if (StringUtils.isEmpty((CharSequence)tableName)) continue;
            StringBuffer sql = new StringBuffer(maint).append(tableName);
            context.getExecutor().execute(sql.toString());
        }
    }
}

