/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.spi;

import com.swak.archiver.ArchiveHandler;
import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.common.chain.FilterInvoker;
import com.swak.common.exception.ArchiveException;
import com.swak.common.util.GetterUtil;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxIdHandler
implements ArchiveHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaxIdHandler.class);

    public void doFilter(ArchiveItem context, FilterInvoker<ArchiveItem> nextFilter) {
        ArchiveConfig config = context.getConfig();
        try {
            if (context.getDataCount() <= 0) {
                log.warn("\u539f\u59cb\u8868\u6570\u83b7\u53d6 - \u539f\u59cb\u8868: {} - \u9700\u8981\u5904\u7406\u6570\u4e3a0 - where\u6761\u4ef6: {}", new Object[]{config.getSrcTblName(), config.getWhere()});
                nextFilter.invoke((Object)context);
                return;
            }
            StringBuilder builderSql = new StringBuilder();
            builderSql.append("SELECT MAX(id) FROM ").append(config.getSrcTblName());
            builderSql.append(" ").append(config.getWhere());
            Long maxId = context.getExecutor().findMaxId(builderSql.toString());
            log.warn("maxId\u83b7\u53d6 - \u539f\u59cb\u8868: {} - \u6700\u5927max(id) :{} - where\u6761\u4ef6: {}", new Object[]{config.getSrcTblName(), maxId, config.getWhere()});
            context.setMaxId(maxId);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u539f\u59cb\u8868maxId\u62a5\u9519  - \u5f52\u6863\u8868 \uff1a{} - where\u6761\u4ef6: {} - \u5f02\u5e38\u4fe1\u606f\uff1a {}", new Object[]{config.getSrcTblName(), config.getWhere(), e.getMessage()});
            throw new ArchiveException((Throwable)e);
        }
        if (!config.isPurge()) {
            this.handlerNextMaxId(context);
        }
        nextFilter.invoke((Object)context);
    }

    protected void handlerNextMaxId(ArchiveItem item) {
        ArchiveConfig config = item.getConfig();
        try {
            StringBuilder builderSql = new StringBuilder();
            builderSql.append("SELECT MAX(id) FROM ").append(config.getDesTblName());
            Long maxId = item.getExecutor().findMaxId(builderSql.toString());
            log.warn("\u76ee\u6807\u8868nextMaxId\u83b7\u53d6 - \u76ee\u6807\u8868: {} - nextMaxId(id) :{}", new Object[]{config.getDesTblName(), maxId});
            item.setNextMaxId(GetterUtil.getLong((Long)maxId, (Long)0L));
        }
        catch (Exception e) {
            log.error("\u76ee\u6807\u8868nextMaxId\u83b7\u53d6 - \u76ee\u6807\u8868: {}  - \u5f02\u5e38\u4fe1\u606f\uff1a {}", (Object)config.getDesTblName(), (Object)e.getMessage());
            throw new ArchiveException((Throwable)e);
        }
    }
}

