/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.spi;

import com.google.common.collect.Sets;
import com.swak.archiver.ArchiveHandler;
import com.swak.archiver.conf.ArchiveConfig;
import com.swak.archiver.conf.ArchiveItem;
import com.swak.common.chain.FilterInvoker;
import com.swak.common.exception.ArchiveException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class TableCheckHandler
implements ArchiveHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableCheckHandler.class);

    public void doFilter(ArchiveItem context, FilterInvoker<ArchiveItem> nextFilter) {
        ArchiveConfig config = context.getConfig();
        if (!config.isArchive()) {
            log.warn("\u5220\u9664\u5386\u53f2\u6570\u636e\u4e0d\u8df3\u8fc7check\u5b57\u6bb5\u4e00\u81f4\u6027\uff0c tableName\uff1a{}", (Object)config.getSrcTblName());
            nextFilter.invoke((Object)context);
            return;
        }
        List<String> srcCols = this.getTableCols(context, config.getSrcTblName());
        List<String> desCols = this.getTableCols(context, config.getDesTblName());
        if (!ArrayUtils.toString((Object)Sets.newTreeSet(srcCols)).equals(ArrayUtils.toString((Object)Sets.newTreeSet(desCols)))) {
            ArchiveException.throwException((String)"\u539f\u59cb\u8868\uff1a{},\u4e0e\u76ee\u6807\u8868:{} \u5b57\u6bb5\u4e0d\u4e00\u81f4", (Object[])new Object[]{config.getSrcTblName(), config.getDesTblName()});
        }
        context.setCols(srcCols.toArray(new String[srcCols.size()]));
        nextFilter.invoke((Object)context);
    }

    protected List<String> getTableCols(ArchiveItem item, String tblName) {
        ArrayList<String> colsName = new ArrayList<String>();
        try {
            StringBuilder builderSql = new StringBuilder();
            builderSql.append("SELECT * FROM ").append(tblName).append(" limit 0,0 ");
            SqlRowSet rowSet = item.getExecutor().queryForRowSet(builderSql.toString());
            SqlRowSetMetaData metaData = rowSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                colsName.add(metaData.getColumnName(i));
            }
        }
        catch (DataAccessException e) {
            log.error("\u83b7\u53d6\u8868\u5b57\u6bb5\u62a5\u9519  tableName\uff1a{}", (Object)tblName, (Object)e);
            ArchiveException.throwException((Throwable)e);
        }
        return colsName;
    }
}

