/*
 * Decompiled with CFR 0.152.
 */
package com.swak.archiver.spring.configuration;

import com.swak.archiver.common.SwakTemplateExecutorImpl;
import com.swak.archiver.conf.ArchiverProperties;
import com.swak.archiver.executor.ClickArchiverEngineExecutor;
import com.swak.archiver.executor.MysqlArchiverEngineExecutor;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={ArchiverProperties.class})
public class ArchiverAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MysqlArchiverEngineExecutor.class})
    @ConditionalOnBean(value={ArchiverProperties.class})
    public MysqlArchiverEngineExecutor mysqlArchiverDataEngine(ArchiverProperties archiverProperties) {
        SwakTemplateExecutorImpl mysqlTemplateExecutor = null;
        if (Objects.nonNull(archiverProperties.getMysqlDataSource())) {
            mysqlTemplateExecutor = new SwakTemplateExecutorImpl(archiverProperties.getMysqlDataSource(), true);
        }
        return new MysqlArchiverEngineExecutor(mysqlTemplateExecutor, archiverProperties.getMonitor());
    }

    @Bean
    @ConditionalOnMissingBean(value={ClickArchiverEngineExecutor.class})
    @ConditionalOnBean(value={ArchiverProperties.class})
    public ClickArchiverEngineExecutor clickArchiverDataEngine(ArchiverProperties archiverProperties) {
        SwakTemplateExecutorImpl mysqlTemplateExecutor = null;
        if (Objects.nonNull(archiverProperties.getMysqlDataSource())) {
            mysqlTemplateExecutor = new SwakTemplateExecutorImpl(archiverProperties.getClickhouseDataSource(), false);
        }
        return new ClickArchiverEngineExecutor(mysqlTemplateExecutor, archiverProperties.getMonitor());
    }
}

