/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.mingbaobaba.security.oauth2.repository;

import io.gitee.mingbaobaba.security.core.utils.DateUtil;
import io.gitee.mingbaobaba.security.oauth2.domain.SecurityOauth2Client;
import io.gitee.mingbaobaba.security.oauth2.repository.SecurityOauth2Repository;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class SecurityOauth2RepositoryDefaultImpl
implements SecurityOauth2Repository {
    private static final String CREATE_TIME_KEY = "createTime";
    private static final String TIME_OUT_KEY = "timeOut";
    private static final String OBJECT_KEY = "storeObj";
    private static final AtomicReference<Map<String, Map<String, Object>>> authorizationCodeMap = new AtomicReference(new ConcurrentHashMap());
    private static final AtomicReference<Map<String, Map<String, Object>>> tokenMap = new AtomicReference(new ConcurrentHashMap());

    @Override
    public void saveAuthorizationCode(String authorizationCode, SecurityOauth2Client securityClientMode, long timeout) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CREATE_TIME_KEY, DateUtil.formatDateTime.apply(new Date()));
        map.put(TIME_OUT_KEY, timeout);
        map.put(OBJECT_KEY, securityClientMode);
        authorizationCodeMap.get().put(authorizationCode, map);
    }

    @Override
    public SecurityOauth2Client getClientModelByAuthorizationCode(String authorizationCode) {
        Map<String, Object> map = authorizationCodeMap.get().get(authorizationCode);
        if (Objects.isNull(map)) {
            return null;
        }
        long timeout = (Long)map.get(TIME_OUT_KEY);
        String createTime = (String)map.get(CREATE_TIME_KEY);
        if (((LocalDateTime)DateUtil.strToLocalDateTime.apply(createTime)).plusSeconds(timeout).isBefore(LocalDateTime.now())) {
            authorizationCodeMap.get().remove(authorizationCode);
            return null;
        }
        return (SecurityOauth2Client)map.get(OBJECT_KEY);
    }

    @Override
    public void removeAuthorizationCode(String authorizationCode) {
        authorizationCodeMap.get().remove(authorizationCode);
    }

    @Override
    public boolean saveAccessAndRefreshToken(String accessToken, String refreshToken, Long timeout) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CREATE_TIME_KEY, DateUtil.formatDateTime.apply(new Date()));
        map.put(TIME_OUT_KEY, timeout);
        map.put(OBJECT_KEY, accessToken);
        tokenMap.get().put(refreshToken, map);
        return true;
    }

    @Override
    public String accessTokenByRefreshToken(String refreshToken) {
        Map<String, Object> map = tokenMap.get().get(refreshToken);
        if (Objects.isNull(map)) {
            return null;
        }
        String createTime = (String)map.get(CREATE_TIME_KEY);
        long timeout = (Long)map.get(TIME_OUT_KEY);
        if (((LocalDateTime)DateUtil.strToLocalDateTime.apply(createTime)).plusSeconds(timeout).isBefore(LocalDateTime.now())) {
            authorizationCodeMap.get().remove(refreshToken);
            return null;
        }
        return (String)map.get(OBJECT_KEY);
    }

    @Override
    public Long refreshTokenTimeOut(String refreshToken) {
        Map<String, Object> map = tokenMap.get().get(refreshToken);
        if (Objects.isNull(map)) {
            return null;
        }
        String createTime = (String)map.get(CREATE_TIME_KEY);
        long timeout = (Long)map.get(TIME_OUT_KEY);
        long second = ((LocalDateTime)DateUtil.strToLocalDateTime.apply(createTime)).plusSeconds(timeout).toEpochSecond(ZoneOffset.ofHours(8)) - LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8));
        return second > 0L ? second : 0L;
    }
}

