/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.mingbaobaba.security.oauth2.service;

import io.gitee.mingbaobaba.security.core.context.SecurityContext;
import io.gitee.mingbaobaba.security.core.domain.SecurityLoginParams;
import io.gitee.mingbaobaba.security.core.domain.SecuritySession;
import io.gitee.mingbaobaba.security.core.domain.SecurityToken;
import io.gitee.mingbaobaba.security.core.domain.SecurityUserDetails;
import io.gitee.mingbaobaba.security.core.exception.SecurityBusinessException;
import io.gitee.mingbaobaba.security.core.factory.SecurityFactory;
import io.gitee.mingbaobaba.security.core.request.SecurityRequest;
import io.gitee.mingbaobaba.security.core.service.SecurityService;
import io.gitee.mingbaobaba.security.core.service.SecurityUserDetailsService;
import io.gitee.mingbaobaba.security.core.utils.CommonUtil;
import io.gitee.mingbaobaba.security.core.utils.SecurityUtil;
import io.gitee.mingbaobaba.security.oauth2.SecurityOauth2Manager;
import io.gitee.mingbaobaba.security.oauth2.domain.SecurityOauth2AccessToken;
import io.gitee.mingbaobaba.security.oauth2.domain.SecurityOauth2Application;
import io.gitee.mingbaobaba.security.oauth2.domain.SecurityOauth2Client;
import io.gitee.mingbaobaba.security.oauth2.domain.SecurityOauth2RefreshToken;
import io.gitee.mingbaobaba.security.oauth2.enums.GrantType;
import io.gitee.mingbaobaba.security.oauth2.exception.SecurityOauth2Exception;
import io.gitee.mingbaobaba.security.oauth2.repository.SecurityOauth2ApplicationRepository;
import io.gitee.mingbaobaba.security.oauth2.repository.SecurityOauth2Repository;
import io.gitee.mingbaobaba.security.oauth2.service.SecurityOauth2Service;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SecurityOauth2ServiceImpl
implements SecurityOauth2Service {
    @Override
    public SecurityOauth2Client buildLoginModel(GrantType grantType) {
        SecurityRequest securityRequest = (SecurityRequest)SecurityFactory.getSecurityRequest.get();
        SecurityOauth2ApplicationRepository applicationRepository = SecurityOauth2Manager.getSecurityOauth2ApplicationRepository();
        String basic = securityRequest.getHeader("Basic");
        String clientId = "";
        String clientSecret = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{basic})) {
            String basicStr = Arrays.toString(Base64.getDecoder().decode(basic));
            String[] basicArr = basicStr.split(",");
            if (basicArr.length == 2) {
                clientId = Objects.isNull(basicArr[0]) ? "" : basicArr[0];
                clientSecret = Objects.isNull(basicArr[1]) ? "" : basicArr[1];
            }
        } else {
            clientId = securityRequest.getParameterNonNull("client_id");
            clientSecret = securityRequest.getParameterNonNull("client_secret");
        }
        SecurityOauth2Application securityOauth2Application = applicationRepository.getOauth2ApplicationByClientId(clientId);
        if (Objects.isNull(securityOauth2Application)) {
            throw new SecurityOauth2Exception("2001", "\u5ba2\u6237\u7aef\u672a\u6388\u6743");
        }
        if (!clientSecret.equals(securityOauth2Application.getClientSecret())) {
            throw new SecurityOauth2Exception("2002", "\u5ba2\u6237\u7aef\u5bc6\u94a5\u9519\u8bef");
        }
        String scope = SecurityOauth2ServiceImpl.validScope(securityRequest, securityOauth2Application);
        String responseType = SecurityOauth2ServiceImpl.validResponseType(securityRequest);
        SecurityOauth2ServiceImpl.validGrantType(grantType, securityOauth2Application);
        String state = securityRequest.getParameter("state");
        String redirectUri = SecurityOauth2ServiceImpl.validRedirectUri(securityRequest, grantType, securityOauth2Application);
        return SecurityOauth2Client.builder().clientId(clientId).clientName(StringUtils.defaultString((String)securityOauth2Application.getClientName(), (String)clientId)).clientSecret(clientSecret).responseType(responseType).scope(scope).redirectUri(redirectUri).state(state).build();
    }

    private static String validScope(SecurityRequest securityRequest, SecurityOauth2Application application) {
        String scope = securityRequest.getParameterNonNull("scope");
        if (Objects.isNull(application.getScope()) || Stream.of(application.getScope().split(",")).noneMatch(str -> str.equals(scope))) {
            throw new SecurityOauth2Exception("2003", "\u5ba2\u6237\u7aef\u6388\u6743\u8303\u56f4\u9519\u8bef");
        }
        return scope;
    }

    private static String validResponseType(SecurityRequest securityRequest) {
        String responseType = securityRequest.getParameter("response_type");
        if (StringUtils.isBlank((CharSequence)responseType)) {
            responseType = (String)securityRequest.getAttribute("response_type");
        }
        if (!"code".equals(responseType) && !"token".equals(responseType)) {
            throw new SecurityOauth2Exception("2005", "\u5ba2\u6237\u7aef\u8bf7\u6c42\u8fd4\u56de\u7c7b\u578b\u9519\u8bef");
        }
        return responseType;
    }

    private static void validGrantType(GrantType grantType, SecurityOauth2Application application) {
        if (Objects.isNull(application.getGrantType()) || Stream.of(application.getGrantType().split(",")).noneMatch(str -> str.equals(grantType.getCode()))) {
            throw new SecurityOauth2Exception("2005", "\u4e0d\u652f\u6301\u6b64\u6388\u6743\u7c7b\u578b");
        }
    }

    private static String validRedirectUri(SecurityRequest securityRequest, GrantType grantType, SecurityOauth2Application application) {
        String redirectUri;
        if (GrantType.PASSWORD.getCode().equals(grantType.getCode()) || GrantType.CLIENT_CREDENTIALS.getCode().equals(grantType.getCode())) {
            redirectUri = null;
        } else {
            redirectUri = securityRequest.getParameterNonNull("redirect_uri");
            if (Objects.isNull(application.getRedirectUri()) || Stream.of(application.getRedirectUri().split(",")).noneMatch(str -> str.equals(redirectUri))) {
                throw new SecurityOauth2Exception("2004", "\u5ba2\u6237\u7aef\u56de\u8c03\u5730\u5740\u672a\u6388\u6743");
            }
        }
        return redirectUri;
    }

    @Override
    public String generateAuthorizationCode() {
        SecurityRequest securityRequest = (SecurityRequest)SecurityFactory.getSecurityRequest.get();
        String username = securityRequest.getParameterNonNull("username");
        String password = securityRequest.getParameterNonNull("password");
        SecurityUserDetailsService userDetailsService = (SecurityUserDetailsService)SecurityFactory.getSecurityUserDetailsService.get();
        SecurityContext securityContext = (SecurityContext)SecurityFactory.getSecurityContext.get();
        SecurityLoginParams loginParams = new SecurityLoginParams();
        SecurityUserDetails userDetails = userDetailsService.findSecurityUserDetailsByUsername(username);
        if (Objects.isNull(userDetails) || StringUtils.isBlank((CharSequence)userDetails.getLoginId())) {
            throw new SecurityOauth2Exception("1019", "\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!userDetailsService.preHandle(username, loginParams, securityContext)) {
            throw new SecurityOauth2Exception("1022", "\u767b\u5f55\u64cd\u4f5c\u88ab\u9650\u5236");
        }
        if (StringUtils.isBlank((CharSequence)userDetails.getPassword()) || !userDetails.getPassword().equals(userDetailsService.passwordPolicy(password, userDetails, securityContext))) {
            throw new SecurityOauth2Exception("1020", "\u5bc6\u7801\u9519\u8bef");
        }
        SecurityOauth2Client securityClientModel = this.buildLoginModel(GrantType.AUTHORIZATION_CODE);
        securityClientModel.setUsername(username);
        securityClientModel.setPassword(password);
        String authorizationCode = (String)CommonUtil.generateToken.get();
        SecurityOauth2Repository securityOauth2Repository = SecurityOauth2Manager.getSecurityOauth2Repository();
        securityOauth2Repository.saveAuthorizationCode(authorizationCode, securityClientModel, 600L);
        return authorizationCode;
    }

    @Override
    public String buildAuthorizationCodeUri(String authorizationCode) {
        SecurityOauth2Repository securityOauth2Repository = SecurityOauth2Manager.getSecurityOauth2Repository();
        SecurityOauth2Client securityClientModel = securityOauth2Repository.getClientModelByAuthorizationCode(authorizationCode);
        if (null == securityClientModel) {
            throw new SecurityOauth2Exception("2006", "\u6388\u6743\u7801\u5df2\u5931\u6548");
        }
        String redirectUri = securityClientModel.getRedirectUri();
        return redirectUri + (redirectUri.contains("?") ? "&" : "?") + "code=" + authorizationCode + "&state=" + (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{securityClientModel.getState()}) ? securityClientModel.getState() : "");
    }

    @Override
    public SecurityOauth2AccessToken getAccessTokenByAuthorizationCode(String authorizationCode) {
        SecurityOauth2Repository securityOauth2Repository = SecurityOauth2Manager.getSecurityOauth2Repository();
        SecurityOauth2Client clientModel = securityOauth2Repository.getClientModelByAuthorizationCode(authorizationCode);
        if (Objects.isNull(clientModel)) {
            throw new SecurityOauth2Exception("2006", "\u65e0\u6548\u7684\u6388\u6743\u7801");
        }
        securityOauth2Repository.removeAuthorizationCode(authorizationCode);
        return this.grantAuthorizationLogin(clientModel, GrantType.AUTHORIZATION_CODE);
    }

    @Override
    public void revokeAuthorization(String authorizationCode) {
        SecurityOauth2Repository securityOauth2Repository = SecurityOauth2Manager.getSecurityOauth2Repository();
        securityOauth2Repository.removeAuthorizationCode(authorizationCode);
    }

    @Override
    public SecurityOauth2AccessToken grantAuthorizationLogin(SecurityOauth2Client clientModel, GrantType grantType) {
        SecurityRequest securityRequest = (SecurityRequest)SecurityFactory.getSecurityRequest.get();
        SecurityContext securityContext = (SecurityContext)SecurityFactory.getSecurityContext.get();
        SecurityLoginParams loginParams = new SecurityLoginParams();
        loginParams.setTokenAttribute("client_id", (Object)clientModel.getClientId()).setTokenAttribute("grant_type", (Object)grantType.getCode()).setTokenAttribute("scope", (Object)clientModel.getScope()).setTokenAttribute("state", (Object)clientModel.getState()).setTimeout(SecurityOauth2Manager.getConfig().getRefreshTokenTimeout()).setActivityTimeout(SecurityOauth2Manager.getConfig().getAccessTokenTimeout());
        SecurityOauth2Repository securityOauth2Repository = SecurityOauth2Manager.getSecurityOauth2Repository();
        if (GrantType.CLIENT_CREDENTIALS.getCode().equals(grantType.getCode())) {
            SecurityUtil.doLogin((String)clientModel.getClientId(), (SecurityLoginParams)loginParams);
        } else {
            SecurityUserDetails userDetails;
            SecurityUserDetailsService userDetailsService = (SecurityUserDetailsService)SecurityFactory.getSecurityUserDetailsService.get();
            if (StringUtils.isBlank((CharSequence)clientModel.getUsername())) {
                String username = securityRequest.getParameterNonNull("username");
                clientModel.setUsername(username);
            }
            if (Objects.isNull(userDetails = userDetailsService.findSecurityUserDetailsByUsername(clientModel.getUsername())) || StringUtils.isBlank((CharSequence)userDetails.getLoginId())) {
                throw new SecurityOauth2Exception("1019", "\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728");
            }
            if (Boolean.FALSE.equals(((SecurityUserDetailsService)SecurityFactory.getSecurityUserDetailsService.get()).preHandle(clientModel.getUsername(), loginParams, securityContext))) {
                throw new SecurityBusinessException("1022", "\u767b\u5f55\u64cd\u4f5c\u88ab\u9650\u5236");
            }
            if (StringUtils.isBlank((CharSequence)clientModel.getPassword())) {
                String password = securityRequest.getParameterNonNull("password");
                clientModel.setPassword(password);
            }
            if (StringUtils.isBlank((CharSequence)userDetails.getPassword()) || !userDetails.getPassword().equals(userDetailsService.passwordPolicy(clientModel.getPassword(), userDetails, securityContext))) {
                throw new SecurityOauth2Exception("1020", "\u5bc6\u7801\u9519\u8bef");
            }
            SecurityUtil.doLogin((String)userDetails.getLoginId(), (SecurityLoginParams)loginParams);
            userDetailsService.afterCompletion();
        }
        SecuritySession session = SecurityUtil.getCurrentSecuritySession();
        SecurityToken securityToken = session.getCurrentSecurityToken();
        SecurityOauth2AccessToken oauth2AccessToken = new SecurityOauth2AccessToken();
        oauth2AccessToken.setAccessToken(securityToken.getToken());
        oauth2AccessToken.setExpiresIn(securityToken.getActivityTimeout());
        oauth2AccessToken.setIssuedAt(session.getCreateTime());
        if (GrantType.AUTHORIZATION_CODE.getCode().equals(grantType.getCode()) || GrantType.PASSWORD.getCode().equals(grantType.getCode())) {
            oauth2AccessToken.setRefreshToken((String)CommonUtil.generateToken.get());
            oauth2AccessToken.setRefreshExpiresIn(securityToken.getTimeout());
            if (!securityOauth2Repository.saveAccessAndRefreshToken(oauth2AccessToken.getAccessToken(), oauth2AccessToken.getRefreshToken(), oauth2AccessToken.getRefreshExpiresIn())) {
                throw new SecurityOauth2Exception("2007", "\u4fdd\u5b58Oauth2AccessToken\u5f02\u5e38");
            }
        }
        return oauth2AccessToken;
    }

    @Override
    public String buildImplicitGrantUri() {
        SecurityOauth2Client securityClientModel = this.buildLoginModel(GrantType.IMPLICIT);
        SecurityOauth2AccessToken securityOauth2AccessToken = this.grantAuthorizationLogin(securityClientModel, GrantType.IMPLICIT);
        String redirectUri = securityClientModel.getRedirectUri();
        return redirectUri + (redirectUri.contains("?") ? "&" : "?") + "accessToken=" + securityOauth2AccessToken.getAccessToken() + "&expiresIn=" + securityOauth2AccessToken.getExpiresIn() + "&tokenType=" + securityOauth2AccessToken.getTokenType() + "&state=" + (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{securityClientModel.getState()}) ? securityClientModel.getState() : "");
    }

    @Override
    public SecurityOauth2RefreshToken refreshToken() {
        SecurityRequest securityRequest = (SecurityRequest)SecurityFactory.getSecurityRequest.get();
        String refreshToken = securityRequest.getParameterNonNull("refresh_token");
        SecurityOauth2Repository securityOauth2Repository = SecurityOauth2Manager.getSecurityOauth2Repository();
        String accessToken = securityOauth2Repository.accessTokenByRefreshToken(refreshToken);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new SecurityOauth2Exception("2009", "refreshToken\u5df2\u5931\u6548");
        }
        SecurityService securityService = (SecurityService)SecurityFactory.getSecurityService.get();
        SecuritySession session = securityService.getSecuritySessionByToken(accessToken);
        if (Objects.isNull(session) || Objects.isNull(session.getCurrentSecurityToken())) {
            throw new SecurityOauth2Exception("1007", "\u7eed\u7ea6\u7528\u6237\u4fe1\u606f\u5df2\u5931\u6548");
        }
        session.renewalToken(accessToken, SecurityOauth2Manager.getConfig().getAccessTokenTimeout());
        SecurityOauth2RefreshToken oauth2RefreshToken = new SecurityOauth2RefreshToken();
        oauth2RefreshToken.setAccessToken(accessToken);
        oauth2RefreshToken.setExpiresIn(securityService.tokenTimeout(accessToken));
        oauth2RefreshToken.setRefreshToken(refreshToken);
        oauth2RefreshToken.setRefreshExpiresIn(securityOauth2Repository.refreshTokenTimeOut(refreshToken));
        return oauth2RefreshToken;
    }
}

