/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.mingbaobaba.security.plugin.oauth2.jpa.repository;

import io.gitee.mingbaobaba.security.core.utils.JsonUtil;
import io.gitee.mingbaobaba.security.oauth2.domain.SecurityOauth2Client;
import io.gitee.mingbaobaba.security.oauth2.repository.SecurityOauth2Repository;
import io.gitee.mingbaobaba.security.plugin.oauth2.jpa.entity.SecurityOauth2AccessTokenEntity;
import io.gitee.mingbaobaba.security.plugin.oauth2.jpa.entity.SecurityOauth2AuthorizationEntity;
import io.gitee.mingbaobaba.security.plugin.oauth2.jpa.repository.SecurityOauth2JpaAccessTokenRepository;
import io.gitee.mingbaobaba.security.plugin.oauth2.jpa.repository.SecurityOauth2JpaAuthorizationRepository;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class SecurityOauth2JpaRepository
implements SecurityOauth2Repository {
    @Autowired
    private SecurityOauth2JpaAuthorizationRepository securityOauth2AuthorizationRepository;
    @Autowired
    private SecurityOauth2JpaAccessTokenRepository securityOauth2AccessTokenRepository;

    public void saveAuthorizationCode(String authorizationCode, SecurityOauth2Client securityClientMode, long timeout) {
        SecurityOauth2AuthorizationEntity securityOauth2Authorization = new SecurityOauth2AuthorizationEntity();
        securityOauth2Authorization.setAuthorizationCode(authorizationCode);
        securityOauth2Authorization.setAuthorizationData(JsonUtil.objectToJsonStr((Object)securityClientMode));
        securityOauth2Authorization.setTimeout(timeout);
        securityOauth2Authorization.setCreateTime(LocalDateTime.now());
        securityOauth2Authorization.setUpdateTime(LocalDateTime.now());
        this.securityOauth2AuthorizationRepository.save(securityOauth2Authorization);
    }

    public SecurityOauth2Client getClientModelByAuthorizationCode(String authorizationCode) {
        Optional optional = this.securityOauth2AuthorizationRepository.findById(authorizationCode);
        if (!optional.isPresent()) {
            return null;
        }
        SecurityOauth2AuthorizationEntity securityOauth2Authorization = (SecurityOauth2AuthorizationEntity)optional.get();
        if (securityOauth2Authorization.getCreateTime().plusSeconds(securityOauth2Authorization.getTimeout()).isBefore(LocalDateTime.now())) {
            this.removeAuthorizationCode(authorizationCode);
            return null;
        }
        return (SecurityOauth2Client)JsonUtil.jsonStrToObject((String)securityOauth2Authorization.getAuthorizationData(), SecurityOauth2Client.class);
    }

    public void removeAuthorizationCode(String authorizationCode) {
        this.securityOauth2AuthorizationRepository.deleteById(authorizationCode);
    }

    public boolean saveAccessAndRefreshToken(String accessToken, String refreshToken, Long timeout) {
        SecurityOauth2AccessTokenEntity securityOauth2AccessTokenEntity = new SecurityOauth2AccessTokenEntity();
        securityOauth2AccessTokenEntity.setRefreshToken(refreshToken);
        securityOauth2AccessTokenEntity.setAccessToken(accessToken);
        securityOauth2AccessTokenEntity.setTimeout(timeout);
        securityOauth2AccessTokenEntity.setCreateTime(LocalDateTime.now());
        securityOauth2AccessTokenEntity.setUpdateTime(LocalDateTime.now());
        this.securityOauth2AccessTokenRepository.save(securityOauth2AccessTokenEntity);
        return true;
    }

    public String accessTokenByRefreshToken(String refreshToken) {
        Optional optional = this.securityOauth2AccessTokenRepository.findById(refreshToken);
        if (!optional.isPresent()) {
            return null;
        }
        SecurityOauth2AccessTokenEntity securityOauth2AccessTokenEntity = (SecurityOauth2AccessTokenEntity)optional.get();
        if (securityOauth2AccessTokenEntity.getCreateTime().plusSeconds(securityOauth2AccessTokenEntity.getTimeout()).isBefore(LocalDateTime.now())) {
            this.securityOauth2AccessTokenRepository.deleteById(refreshToken);
            return null;
        }
        return securityOauth2AccessTokenEntity.getAccessToken();
    }

    public Long refreshTokenTimeOut(String refreshToken) {
        Optional optional = this.securityOauth2AccessTokenRepository.findById(refreshToken);
        if (!optional.isPresent()) {
            return 0L;
        }
        SecurityOauth2AccessTokenEntity securityOauth2AccessTokenEntity = (SecurityOauth2AccessTokenEntity)optional.get();
        long timeout = securityOauth2AccessTokenEntity.getCreateTime().plusSeconds(securityOauth2AccessTokenEntity.getTimeout()).toEpochSecond(ZoneOffset.ofHours(8)) - LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8));
        return timeout > 0L ? timeout : 0L;
    }
}

