/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.mingbaobaba.security.plugin.redis.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gitee.mingbaobaba.security.core.domain.SecuritySession;
import io.gitee.mingbaobaba.security.core.repository.SecurityRepository;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SecurityRedisRepository
implements SecurityRepository {
    private static final Logger log = LoggerFactory.getLogger(SecurityRedisRepository.class);
    private final StringRedisTemplate stringRedisTemplate;

    public SecurityRedisRepository(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public SecuritySession getSecuritySessionByLoginId(String loginId) {
        String redisKey = MessageFormat.format("athena:security:session:{0}", loginId);
        String elementStr = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isBlank((CharSequence)elementStr)) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        SecuritySession securitySession = null;
        try {
            securitySession = (SecuritySession)objectMapper.readValue(elementStr, SecuritySession.class);
        }
        catch (JsonProcessingException e) {
            log.error("\u5e8f\u5217\u5316SecuritySession\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
        }
        return securitySession;
    }

    public Long getSessionTimeoutByLoginId(String loginId) {
        String redisKey = MessageFormat.format("athena:security:session:{0}", loginId);
        return this.stringRedisTemplate.getExpire((Object)redisKey);
    }

    public boolean saveSecuritySession(SecuritySession session) {
        return this.saveSecuritySession(session, null);
    }

    public boolean saveSecuritySession(SecuritySession session, Long timeout) {
        String elementStr;
        String redisVersionKey = MessageFormat.format("athena:security:session_version:{0}", session.getLoginId());
        String version = (String)this.stringRedisTemplate.opsForValue().get((Object)redisVersionKey);
        if (Objects.nonNull(session.getVersion()) && StringUtils.isNotBlank((CharSequence)version) && !session.getVersion().equals(Long.parseLong(version))) {
            log.error("\u7248\u672c\u53f7\u9a8c\u8bc1\u5f02\u5e38");
            return false;
        }
        Long newVersion = this.stringRedisTemplate.opsForValue().increment((Object)redisVersionKey);
        this.stringRedisTemplate.expire((Object)redisVersionKey, 30L, TimeUnit.DAYS);
        session.setVersion(newVersion);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            elementStr = objectMapper.writeValueAsString((Object)session);
        }
        catch (JsonProcessingException e) {
            log.error("\u5e8f\u5217\u5316json\u5f02\u5e38", (Throwable)e);
            return false;
        }
        String redisKey = MessageFormat.format("athena:security:session:{0}", session.getLoginId());
        if (null == timeout) {
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)elementStr);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)elementStr, timeout.longValue(), TimeUnit.SECONDS);
        }
        return true;
    }

    public boolean removeSecuritySessionByLoginId(String loginId) {
        String redisKey = MessageFormat.format("athena:security:session:{0}", loginId);
        return Boolean.TRUE.equals(this.stringRedisTemplate.delete((Object)redisKey));
    }

    public String getLoginIdByTokenId(String tokenId) {
        String redisKey = MessageFormat.format("athena:security:token:{0}", tokenId);
        return (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
    }

    public Long getTokenTimeOutByTokenId(String tokenId) {
        String redisKey = MessageFormat.format("athena:security:token:{0}", tokenId);
        return this.stringRedisTemplate.getExpire((Object)redisKey);
    }

    public boolean saveToken(String tokenId, String loginId) {
        return this.saveToken(tokenId, loginId, null);
    }

    public boolean saveToken(String tokenId, String loginId, Long timeout) {
        String redisKey = MessageFormat.format("athena:security:token:{0}", tokenId);
        if (null == timeout) {
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)loginId);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)loginId, timeout.longValue(), TimeUnit.SECONDS);
        }
        return true;
    }

    public boolean removeTokenByTokenId(String tokenId) {
        String redisKey = MessageFormat.format("athena:security:token:{0}", tokenId);
        return Boolean.TRUE.equals(this.stringRedisTemplate.delete((Object)redisKey));
    }

    public List<String> queryTokenList() {
        String redisKey = MessageFormat.format("athena:security:token:{0}", "*");
        Set setList = this.stringRedisTemplate.keys((Object)redisKey);
        return null == setList ? new ArrayList<String>() : setList.stream().map(key -> key.substring(key.lastIndexOf(":") + 1)).collect(Collectors.toList());
    }
}

