/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.opabinia.binlog4j.springboot.starter;

import io.gitee.opabinia.binlog4j.core.config.RedisConfig;
import io.gitee.opabinia.binlog4j.core.position.BinlogPositionHandler;
import io.gitee.opabinia.binlog4j.springboot.starter.Binlog4jAutoProperties;
import io.gitee.opabinia.binlog4j.springboot.starter.Binlog4jInitializationBeanProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;

@AutoConfigureOrder(value=10)
@EnableConfigurationProperties(value={Binlog4jAutoProperties.class})
@ConditionalOnProperty(prefix="spring.binlog4j", name={"enable"}, havingValue="true", matchIfMissing=true)
public class Binlog4jAutoConfiguration {
    private final BinlogPositionHandler positionHandler;

    public Binlog4jAutoConfiguration(@Nullable BinlogPositionHandler positionHandler) {
        this.positionHandler = positionHandler;
    }

    @Bean
    public Binlog4jInitializationBeanProcessor binlog4jAutoInitializing(Binlog4jAutoProperties properties) {
        RedisConfig redisConfig = properties.getRedisConfig();
        properties.getClientConfigs().forEach((clientName, clientConfig) -> {
            if (this.positionHandler != null) {
                clientConfig.setPositionHandler(this.positionHandler);
            }
            if (redisConfig != null && clientConfig.getRedisConfig() == null) {
                clientConfig.setRedisConfig(redisConfig);
            }
        });
        return new Binlog4jInitializationBeanProcessor(properties.getClientConfigs());
    }
}

