/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.opabinia.binlog4j.springboot.starter;

import io.gitee.opabinia.binlog4j.core.BinlogClient;
import io.gitee.opabinia.binlog4j.core.BinlogClientConfig;
import io.gitee.opabinia.binlog4j.core.IBinlogEventHandler;
import io.gitee.opabinia.binlog4j.springboot.starter.annotation.BinlogSubscriber;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Binlog4jInitializationBeanProcessor
implements SmartInitializingSingleton,
ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;
    private final Map<String, BinlogClientConfig> clientConfigs;

    public Binlog4jInitializationBeanProcessor(Map<String, BinlogClientConfig> clientConfigs) {
        this.clientConfigs = clientConfigs;
    }

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"No ApplicationContext set");
        Map handlers = this.applicationContext.getBeansOfType(IBinlogEventHandler.class);
        this.clientConfigs.forEach((clientName, clientConfig) -> {
            BinlogClient client = new BinlogClient(clientConfig);
            handlers.forEach((beanName, handler) -> {
                BinlogSubscriber annotation = (BinlogSubscriber)AnnotationUtils.findAnnotation((Class)AopUtils.getTargetClass((Object)handler), BinlogSubscriber.class);
                if (annotation != null && clientName.equals(annotation.clientName())) {
                    client.registerEventHandler(handler);
                }
            });
            client.connect();
        });
    }
}

