/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.open.nw.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import io.gitee.open.nw.cache.CacheClient;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.index.qual.NonNegative;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.lang.NonNull;

@ConditionalOnMissingBean(value={CacheClient.class})
public class CaffeineCacheClient
implements CacheClient {
    Cache<String, Object> cache = Caffeine.newBuilder().expireAfter((Expiry)new CaffeineExpiry()).initialCapacity(100).maximumSize(10000L).build();

    @Override
    public void delCache(String cacheName, String cacheKey) {
        this.cache.invalidate((Object)(cacheName + "_" + cacheKey));
    }

    @Override
    public <T> void updateCache(String cacheName, String cacheKey, T t) {
        this.cache.put((Object)(cacheName + "_" + cacheKey), t);
    }

    @Override
    public <T> void addCache(String cacheName, String cacheKey, T t) {
        this.cache.put((Object)(cacheName + "_" + cacheKey), t);
    }

    @Override
    public <T> void addCache(String cacheName, String cacheKey, T t, long expireTime) {
        this.cache.policy().expireVariably().ifPresent(e -> e.put((Object)(cacheName + "_" + cacheKey), t, expireTime, TimeUnit.MILLISECONDS));
    }

    @Override
    public <T> T getCache(String cacheName, String cacheKey) {
        return (T)this.cache.get((Object)(cacheName + "_" + cacheKey), key -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String cacheName, String cacheKey, CacheClient.CacheSource<T> cacheSource, Long expireTime) {
        Object result = this.cache.get((Object)(cacheName + "_" + cacheKey), key -> null);
        if (result != null) {
            return (T)result;
        }
        if (cacheSource == null) {
            return null;
        }
        CaffeineCacheClient caffeineCacheClient = this;
        synchronized (caffeineCacheClient) {
            result = this.cache.get((Object)(cacheName + "_" + cacheKey), key -> null);
            if (result != null) {
                return (T)result;
            }
            result = cacheSource.getCache(cacheKey);
            this.addCache(cacheName, cacheKey, result, expireTime);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String cacheName, String cacheKey, CacheClient.CacheSource<T> cacheSource) {
        Object result = this.cache.get((Object)(cacheName + "_" + cacheKey), key -> null);
        if (result != null) {
            return (T)result;
        }
        if (cacheSource == null) {
            return null;
        }
        CaffeineCacheClient caffeineCacheClient = this;
        synchronized (caffeineCacheClient) {
            result = this.cache.get((Object)(cacheName + "_" + cacheKey), key -> null);
            if (result != null) {
                return (T)result;
            }
            result = cacheSource.getCache(cacheKey);
            this.addCache(cacheName, cacheKey, result);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String cacheName, String cacheKey, CacheClient.CacheJudge<T> cacheJudge, CacheClient.CacheSource<T> cacheSource) {
        Object result = this.cache.get((Object)(cacheName + "_" + cacheKey), key -> null);
        if (result != null && cacheJudge.checkCache(result)) {
            return (T)result;
        }
        CaffeineCacheClient caffeineCacheClient = this;
        synchronized (caffeineCacheClient) {
            result = this.cache.get((Object)(cacheName + "_" + cacheKey), key -> null);
            if (result != null && cacheJudge.checkCache(result)) {
                return (T)result;
            }
            result = cacheSource.getCache(cacheKey);
            this.cache.put((Object)(cacheName + "_" + cacheKey), result);
        }
        return (T)result;
    }

    class CaffeineExpiry
    implements Expiry<String, Object> {
        CaffeineExpiry() {
        }

        public long expireAfterCreate(@NonNull String key, @NonNull Object value, long currentTime) {
            return 0L;
        }

        public long expireAfterUpdate(@NonNull String key, @NonNull Object value, long currentTime, @NonNegative long currentDuration) {
            return currentDuration;
        }

        public long expireAfterRead(@NonNull String key, @NonNull Object value, long currentTime, @NonNegative long currentDuration) {
            return currentDuration;
        }
    }
}

