package io.gitee.open.nw.common.base;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 基础的视图类
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
@Schema
public class BaseVo implements Serializable {

    @Schema(description = "创建者Id", example = "2022-05-08 12:56:34")
    private Long creator;

    @Schema(description = "创建时间", example = "2022-05-08 12:56:34")
    private LocalDateTime createTime;

    @Schema(description = "更新者Id", example = "2022-05-08 12:56:34")
    private Long updater;

    @Schema(description = "更新时间", example = "2022-05-08 12:56:34")
    private LocalDateTime updateTime;

    @Schema(description = "创建时间", hidden = true, example = "2022-05-08 12:56:34")
    private String createTimePeriod;

    @Schema(description = "更新时间", hidden = true, example = "2022-05-08 12:56:34")
    private String updateTimePeriod;


    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateTimePeriod() {
        return createTimePeriod;
    }

    public void setCreateTimePeriod(String createTimePeriod) {
        this.createTimePeriod = createTimePeriod;
    }

    public String getUpdateTimePeriod() {
        return updateTimePeriod;
    }

    public void setUpdateTimePeriod(String updateTimePeriod) {
        this.updateTimePeriod = updateTimePeriod;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public Long getUpdater() {
        return updater;
    }

    public void setUpdater(Long updater) {
        this.updater = updater;
    }
}
