package io.gitee.open.nw.common.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

/**
 * 统一返回实体
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
@Schema()
public class Result<T> implements Serializable {

    public static <T> Result<T> ok(T t) {
        return reuslt(ResultEnum.SUCCESS, t);
    }

    public static <T> Result<T> ok(T t, String msg) {
        Result<T> reuslt = reuslt(ResultEnum.SUCCESS, t);
        reuslt.msg = msg;
        return reuslt;
    }

    public static <T> Result<T> ok() {
        return reuslt(ResultEnum.SUCCESS, null);
    }

    public void checkCode() {
        if (code != ResultEnum.SUCCESS.code) {
            throw new BizException(ResultEnum.ERROR, msg);
        }
    }

    public static <T> Result<T> result(ResultEnum resultEnum) {
        Result<T> result = new Result<>();
        result.setCode(resultEnum.code);
        result.setMsg(resultEnum.msg);
        return result;
    }

    public static <T> Result<T> result(ResultEnum resultEnum, String msg) {
        Result<T> result = new Result<>();
        result.setCode(resultEnum.code);
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> result(ResultEnum resultEnum, T data, String msg) {
        Result<T> result = new Result<>();
        result.setCode(resultEnum.code);
        result.setData(data);
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> reuslt(ResultEnum type, T t) {
        Result<T> result = new Result<>();
        result.code = type.code;
        result.msg = type.msg;
        result.data = t;
        return result;
    }

    public Result<T> data(T object) {
        this.setData(object);
        return this;
    }

    public Result<T> msg(String msg) {
        this.setMsg(msg);
        return this;
    }

    @Schema(description = "结果代码", example = "0")
    private int code;

    @Schema(description = "结果说明", example = "请求成功")
    private String msg;

    @Schema(description = "请求结果")
    private T data;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
