package io.gitee.open.nw.common.util;

import io.gitee.open.nw.common.base.BizException;
import io.gitee.open.nw.common.base.ResultEnum;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;

/**
 * url 校验
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class UrlChecker {

    public static String getResourceString(String resourcePaht) {
        try {
            Resource resource = new ClassPathResource(resourcePaht);
            InputStream in = resource.getInputStream();
            return IOUtils.toString(in, StandardCharsets.UTF_8);
        } catch (IOException e) {
            throw new BizException(ResultEnum.PARAM_ERROR, e);
        }
    }


    public static void main(String[] args) {
        boolean match = checkUrl("/1/abc", "/?/abc");
        System.out.println(match);
    }

    public static boolean checkUrl(String content, String pattern) {
        // 相同 直接通过
        if (Objects.equals(content, pattern)) {
            return true;
        }
        if (StringUtils.isBlank(pattern)) {
            return false;
        }
        pattern = pattern.replace("*", ".*");
        pattern = pattern.replace("?", "[^/]+");
        return Pattern.matches(pattern, content);
    }
}
