package io.gitee.open.nw.common.util.encrypt;

import java.util.Base64;

/**
 * base64工具类
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class Base64Util {

    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private static final Base64.Decoder DECODER = Base64.getDecoder();


    public static byte[] encode(byte[] src) {
        return ENCODER.encode(src);
    }

    public static byte[] decode(byte[] src) {
        try {
            return DECODER.decode(src);
        } catch (IllegalArgumentException e) {
            return Base64.getMimeDecoder().decode(src);
        }
    }
}
